<div class="container-fluid py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-xxl-9">

            
            <?php
                /** @var \Illuminate\Support\Collection|\App\Models\BlogCategory[] $categories */
                $activeCategory = $categories->firstWhere('id', (int)$category);
            ?>

            <div class="bg-gradient-header rounded-4 p-4 p-md-5 mb-4 text-white position-relative overflow-hidden shadow-lg header-card">
                <div class="d-flex align-items-center justify-content-between flex-wrap gap-3 position-relative">
                    <div>
                        <div class="d-inline-flex align-items-center gap-2 px-3 py-1 rounded-pill bg-white bg-opacity-10 small mb-2">
                            <i class="ti ti-news"></i>
                            <span>مرکز اخبار و اطلاعیه‌ها</span>
                        </div>
                        <h2 class="mb-1 fw-bold fs-3">
                            <?php if($activeCategory): ?>
                                اخبار دسته: «<?php echo e($activeCategory->name); ?>»
                            <?php else: ?>
                                اخبار و اطلاعیه‌های شرکت
                            <?php endif; ?>
                        </h2>
                        <p class="mb-0 opacity-90 small">
                            <?php if($search && $activeCategory): ?>
                                نتایج جستجو برای
                                <strong>«<?php echo e($search); ?>»</strong>
                                در دسته
                                <strong>«<?php echo e($activeCategory->name); ?>»</strong>.
                            <?php elseif($search): ?>
                                نتایج جستجو برای
                                <strong>«<?php echo e($search); ?>»</strong>
                                در همه دسته‌ها.
                            <?php elseif($activeCategory): ?>
                                نمایش پست‌های منتشر شده در دسته
                                <strong>«<?php echo e($activeCategory->name); ?>»</strong>.
                            <?php else: ?>
                                آخرین به‌روزرسانی‌ها، اطلاعیه‌های داخلی و اخبار مهم سازمانی.
                            <?php endif; ?>
                        </p>
                    </div>

                    <div class="d-flex flex-column align-items-end gap-2">
                        <?php if($isAdmin): ?>
                            <a href="<?php echo e(route('admin.create.post')); ?>"
                               class="btn btn-light text-primary-dark rounded-pill px-4 fw-bold shadow-sm hover-scale d-flex align-items-center gap-2">
                                <i class="ti ti-plus fs-5"></i>
                                ایجاد پست جدید
                            </a>
                        <?php endif; ?>
                        <div class="small opacity-75">
                            تعداد پست‌های منتشر شده: <strong><?php echo e($posts->total()); ?></strong>
                        </div>
                    </div>
                </div>

                <div class="header-card-icon">
                    <i class="ti ti-bell-ringing opacity-50"></i>
                </div>
            </div>

            
            <div class="bg-white rounded-4 p-3 p-md-4 shadow-sm mb-3 filter-container">
                <div class="row g-3 align-items-center">
                    
                    <div class="col-12 col-md-6">
                        <label class="form-label small text-muted mb-1">
                            جستجو در عنوان و متن
                        </label>
                        <div class="input-group input-group-sm search-box-improved">
                            <span class="input-group-text bg-white">
                                <i class="ti ti-search text-primary"></i>
                            </span>
                            <input
                                type="search"
                                class="form-control shadow-none"
                                placeholder="عبارت مورد نظر خود را وارد کنید..."
                                wire:model.debounce.400ms="search"
                            >
                        </div>
                    </div>

                    
                    <div class="col-12 col-md-6 text-md-end text-muted small mt-2 mt-md-4">
                        <?php if($search && $activeCategory): ?>
                            نتایج برای «<?php echo e($search); ?>» در دسته «<?php echo e($activeCategory->name); ?>»
                        <?php elseif($search): ?>
                            نتایج برای «<?php echo e($search); ?>» در تمام دسته‌ها
                        <?php elseif($activeCategory): ?>
                            نمایش فقط دسته «<?php echo e($activeCategory->name); ?>»
                        <?php else: ?>
                            تمام پست‌های منتشر شده در حال نمایش هستند.
                        <?php endif; ?>
                    </div>
                </div>

                
                <?php if($categories->count() > 0): ?>
                    <div class="mt-3 pt-2 border-top">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <span class="small text-muted">
                                فیلتر بر اساس دسته‌بندی
                            </span>
                            <?php if($category !== ''): ?>
                                <button
                                    type="button"
                                    class="btn btn-link btn-sm text-decoration-none small text-danger p-0"
                                    wire:click="$set('category', '')"
                                >
                                    حذف فیلتر دسته
                                </button>
                            <?php endif; ?>
                        </div>

                        <div class="category-scroll d-flex flex-nowrap gap-2 pb-1">
                            
                            <button
                                type="button"
                                wire:click="$set('category', '')"
                                class="btn btn-sm rounded-pill fw-medium category-pill <?php echo e($category === '' ? 'category-pill-active' : 'category-pill-default'); ?>"
                            >
                                <i class="ti ti-category-2 me-1"></i>
                                همه دسته‌ها
                            </button>

                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <button
                                    type="button"
                                    wire:click="$set('category', '<?php echo e($cat->id); ?>')"
                                    class="btn btn-sm rounded-pill fw-medium category-pill
                                        <?php echo e((string)$category === (string)$cat->id ? 'category-pill-active' : 'category-pill-default'); ?>"
                                >
                                    <i class="ti ti-tag me-1"></i>
                                    <?php echo e($cat->name); ?>

                                    <?php if($cat->published_posts_count): ?>
                                        <span class="badge bg-white text-primary rounded-pill ms-1 small">
                                            <?php echo e($cat->published_posts_count); ?>

                                        </span>
                                    <?php endif; ?>
                                </button>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            
            <div wire:loading.delay class="text-center my-3">
                <div class="spinner-border spinner-border-sm text-primary" role="status">
                    <span class="visually-hidden">در حال بارگذاری...</span>
                </div>
            </div>

            
            <div wire:loading.class="opacity-50" wire:target="search,page,category">

                <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $isNew = $post->created_at->gt(now()->subDays(3));
                    ?>

                    <div class="post-card rounded-4 border-0 shadow-sm mb-3 overflow-hidden position-relative">
                        <?php if($isNew): ?>
                            <span class="badge-new">
                                جدید
                            </span>
                        <?php endif; ?>

                        <div class="row g-0">
                            <?php if($post->image): ?>
                                <div class="col-md-4 d-none d-md-block">
                                    <div class="post-thumb-wrapper h-100">
                                        <img
                                            src="<?php echo e(asset('storage/' . $post->image)); ?>"
                                            alt="<?php echo e($post->title); ?>"
                                            class="img-fluid post-thumb-img"
                                        >
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="<?php echo e($post->image ? 'col-md-8' : 'col-12'); ?>">
                                <div class="post-card-body h-100 d-flex flex-column">
                                    <div class="d-flex justify-content-between align-items-start gap-2 mb-2">
                                        <div class="flex-grow-1">
                                            <h5 class="fw-bold mb-1 text-truncate" title="<?php echo e($post->title); ?>">
                                                <?php echo e($post->title); ?>

                                            </h5>
                                            <div class="small text-muted d-flex flex-wrap align-items-center gap-2">
                                                <span>
                                                    <i class="ti ti-calendar-event me-1"></i>
                                                    <?php echo e($post->created_at->translatedFormat('j F Y')); ?>

                                                </span>
                                                <span class="text-secondary opacity-75">
                                                    • <?php echo e($post->created_at->diffForHumans()); ?>

                                                </span>
                                                <?php if($post->category): ?>
                                                    <span class="badge rounded-pill bg-primary-subtle text-primary small">
                                                        <i class="ti ti-tag me-1"></i>
                                                        <?php echo e($post->category->name); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <?php if($post->author): ?>
                                            <div class="text-end small text-muted ms-2 d-none d-md-block">
                                                <div class="fw-semibold">
                                                    <i class="ti ti-user-circle me-1"></i>
                                                    <?php echo e($post->author->name); ?>

                                                </div>
                                                <div class="opacity-75">نویسنده</div>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <p class="post-excerpt mb-3">
                                        <?php echo e(\Illuminate\Support\Str::limit(strip_tags($post->content), 220)); ?>

                                    </p>

                                    <div class="mt-auto d-flex justify-content-between align-items-center">
                                        <div class="d-flex flex-wrap align-items-center gap-2 small text-muted">
                                            <?php if($post->media_file): ?>
                                                <a href="<?php echo e(asset('storage/' . $post->media_file)); ?>"
                                                   class="badge rounded-pill bg-gray-100 text-secondary text-decoration-none d-inline-flex align-items-center gap-1"
                                                   target="_blank">
                                                    <i class="ti ti-paperclip"></i>
                                                    فایل پیوست
                                                </a>
                                            <?php endif; ?>
                                        </div>

                                        <a href="<?php echo e(route('post.show', $post->id)); ?>"
                                           class="btn btn-sm btn-outline-primary rounded-pill px-3 d-inline-flex align-items-center gap-1 hover-scale">
                                            <span>ادامه مطلب</span>
                                            <i class="ti ti-arrow-left fs-6"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center py-5 bg-white rounded-4 shadow-sm border border-dashed border-gray-200">
                        <div class="p-4 bg-gray-50 rounded-circle d-inline-block mb-3">
                            <i class="ti ti-news-off fs-1 text-muted opacity-50"></i>
                        </div>
                        <h5 class="text-muted fw-bold mb-2">خبری برای نمایش وجود ندارد</h5>
                        <p class="text-muted mb-0 small">
                            فیلترها را تغییر دهید یا بعداً دوباره سر بزنید.
                        </p>
                    </div>
                <?php endif; ?>

                
                <?php if($posts->hasPages()): ?>
                    <div class="d-flex justify-content-center mt-4">
                        <div class="pagination-wrapper rounded-pill shadow-lg p-2 bg-white">
                            <?php echo e($posts->links('pagination.custom-modern')); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <style>
        :root {
            --primary: #0f766e;
            --primary-light: #ccfbf1;
            --primary-dark: #115e59;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-200: #e5e7eb;
        }

        .bg-gradient-header {
            background: radial-gradient(circle at top left, rgba(255,255,255,0.18), transparent 40%),
            linear-gradient(135deg, var(--primary-dark), var(--primary));
        }

        .header-card-icon {
            position: absolute;
            top: -10px;
            left: -10px;
            font-size: 9rem;
            color: rgba(255, 255, 255, 0.08);
            transform: rotate(-15deg);
        }

        .hover-scale {
            transition: transform 0.18s ease, box-shadow 0.18s ease;
        }
        .hover-scale:hover {
            transform: translateY(-1px);
            box-shadow: 0 6px 18px rgba(15, 23, 42, 0.18);
        }

        .search-box-improved .input-group-text,
        .search-box-improved .form-control {
            border: 1px solid var(--gray-200) !important;
            box-shadow: none !important;
        }
        .search-box-improved .input-group-text {
            background-color: var(--gray-50) !important;
        }

        /* دسته‌بندی‌ها (اسکرول افقی) */
        .category-scroll {
            overflow-x: auto;
            scrollbar-width: thin;
            padding-bottom: 4px;
        }
        .category-scroll::-webkit-scrollbar {
            height: 6px;
        }
        .category-scroll::-webkit-scrollbar-thumb {
            background-color: rgba(148, 163, 184, 0.7);
            border-radius: 999px;
        }

        .category-pill {
            white-space: nowrap;
        }
        .category-pill-default {
            background-color: #f3f4f6;
            color: #4b5563;
            border: 1px solid rgba(148, 163, 184, 0.6);
        }
        .category-pill-default:hover {
            background-color: #e5e7eb;
        }
        .category-pill-active {
            background: linear-gradient(135deg, #0f766e, #0ea5e9);
            color: #fff;
            border: none;
            box-shadow: 0 3px 12px rgba(14, 148, 136, 0.45);
        }

        .post-card {
            background: #ffffff;
            box-shadow: 0 8px 22px rgba(15, 23, 42, 0.06);
            transition: transform .18s ease, box-shadow .18s ease, border-color .18s ease;
            border: 1px solid rgba(148, 163, 184, 0.25);
        }
        .post-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 14px 30px rgba(15, 23, 42, 0.12);
            border-color: rgba(15, 118, 110, 0.4);
        }

        .post-card-body {
            padding: 1.25rem 1.4rem;
        }

        .post-thumb-wrapper {
            overflow: hidden;
            border-radius: 1.5rem 0 0 1.5rem;
        }
        .post-thumb-img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transform: scale(1.02);
            transition: transform .25s ease;
        }
        .post-card:hover .post-thumb-img {
            transform: scale(1.06);
        }

        .post-excerpt {
            font-size: 0.9rem;
            color: #4b5563;
            line-height: 1.8;
        }

        .badge-new {
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 2;
            background: linear-gradient(135deg, #22c55e, #16a34a);
            color: #fff;
            font-size: 0.7rem;
            padding: 4px 10px;
            border-radius: 999px;
            box-shadow: 0 3px 10px rgba(34, 197, 94, 0.5);
        }

        .bg-gray-50 {
            background-color: var(--gray-50);
        }
        .bg-gray-100 {
            background-color: var(--gray-100);
        }

        .pagination-wrapper {
            box-shadow: 0 4px 15px rgba(0,0,0,0.06);
            border-radius: 50px;
        }
        .pagination-wrapper .pagination { margin-bottom: 0; }

        .pagination-modern-nav .page-link {
            border: none;
            color: #0f766e;
            font-weight: 500;
            margin: 0 4px;
            min-width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: all 0.2s ease;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        .pagination-modern-nav .page-arrow {
            background-color: var(--gray-100);
            color: #115e59;
        }
        .pagination-modern-nav .page-item.active .page-link {
            background-color: #0f766e !important;
            color: #fff !important;
            font-weight: 700;
            box-shadow: 0 3px 8px rgba(0,0,0,0.2);
        }
        .pagination-modern-nav .page-link:hover:not(.page-item.disabled .page-link):not(.page-item.active .page-link) {
            background-color: var(--primary-light) !important;
            color: #115e59;
        }
        .pagination-modern-nav .page-item.disabled .page-link {
            opacity: 0.4;
            pointer-events: none;
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\user\posts.blade.php ENDPATH**/ ?>