<div class="container-fluid py-5 px-lg-5" dir="rtl" style="font-family: 'Vazirmatn', sans-serif; background: radial-gradient(circle at top right, #fcfdfe, #f1f5f9); min-height: 100vh;">
    <style>
        :root {
            --p-azure: #0ea5e9; --p-indigo: #4361ee; --p-slate: #0f172a;
            --p-border: rgba(226, 232, 240, 0.7); --p-glass: rgba(255, 255, 255, 0.85);
        }

        .reveal-up { animation: luxFadeUp 1s cubic-bezier(0.16, 1, 0.3, 1) both; }
        @keyframes luxFadeUp { from { opacity: 0; transform: translateY(30px) scale(0.98); } to { opacity: 1; transform: translateY(0) scale(1); } }

        /* 🏔️ هدر فرماندهی پانوراما فوق حرفه‌ای */
        .sky-command-center {
            background: linear-gradient(115deg, #1e293b 0%, #0f172a 100%);
            border-radius: 45px; padding: 75px 65px; color: white;
            position: relative; overflow: hidden;
            box-shadow: 0 45px 90px -25px rgba(15, 23, 42, 0.45);
            margin-bottom: 60px; border: 1px solid rgba(255,255,255,0.1);
        }
        .sky-command-center::before {
            content: ''; position: absolute; top: -10%; left: -10%; width: 500px; height: 500px;
            background: radial-gradient(circle, rgba(14, 165, 233, 0.15) 0%, transparent 70%);
            filter: blur(50px);
        }

        /* 📊 ویجت‌های شیشه‌ای پلاتینیوم */
        .glass-widget {
            background: rgba(255, 255, 255, 0.03); backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1); border-radius: 32px; padding: 25px 35px;
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        .glass-widget:hover { border-color: var(--p-azure); transform: translateY(-8px); background: rgba(255, 255, 255, 0.07); }

        /* ✨ بدنه محتوا (Elite Bento Grid) */
        .elite-bento-card {
            background: var(--p-glass); backdrop-filter: blur(30px);
            border-radius: 42px; border: 1px solid #fff;
            box-shadow: 0 30px 60px -15px rgba(0,0,0,0.04);
            overflow: hidden; transition: 0.5s ease;
        }

        /* 📄 کارت‌های فاز عملیاتی */
        .bento-item {
            background: #fff; border-radius: 28px; padding: 35px;
            border: 1px solid #f1f5f9; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
        }
        .bento-item:hover {
            transform: translateY(-12px) scale(1.02);
            border-color: var(--p-azure);
            box-shadow: 0 25px 50px -12px rgba(14, 165, 233, 0.15);
        }

        /* 🖋️ فیلد ورودی کریستالی */
        .crystal-input {
            border-radius: 20px !important; border: 2px solid #edf2f7 !important; padding: 16px 26px !important;
            background: #fff !important; transition: 0.4s; font-weight: 700; color: var(--p-slate);
        }
        .crystal-input:focus { border-color: var(--p-azure) !important; box-shadow: 0 0 0 8px rgba(14, 165, 233, 0.08) !important; }

        /* 🔘 دکمه اکشن نئونی */
        .btn-neon {
            background: var(--p-indigo); color: white; border-radius: 22px;
            padding: 18px 45px; font-weight: 900; border: none; transition: 0.4s;
            box-shadow: 0 15px 30px -5px rgba(67, 97, 238, 0.35);
        }
        .btn-neon:hover { transform: translateY(-5px); box-shadow: 0 20px 40px -5px rgba(67, 97, 238, 0.45); filter: brightness(1.1); }

        .icon-box-lux {
            width: 60px; height: 60px; border-radius: 20px;
            display: flex; align-items: center; justify-content: center;
            background: rgba(14, 165, 233, 0.1); color: var(--p-azure);
            border: 1.5px solid #f1f5f9;
        }
    </style>

    <div class="sky-command-center reveal-up">
        <div class="row align-items-center position-relative z-index-2">
            <div class="col-lg-7">

                <h1 class="fw-black display-2 mb-4 text-white" style="letter-spacing: -3px;">لایه‌های عملیاتی</h1>
                <p class="opacity-50 fs-5 lh-lg mb-0 pe-lg-5 text-justify fw-medium">
                    مهندسی و مدیریت خوشه‌ای فازهای اجرایی پروژه
                    <span class="text-info fw-black"><?php echo e($project->name); ?></span>
                    با استاندارد آرشیو متمرکز.
                </p>
            </div>

            <div class="col-lg-5 mt-5 mt-lg-0">
                <div class="row g-4 justify-content-lg-end">
                    <div class="col-sm-6">
                        <div class="glass-widget text-center">
                            <i class="ti ti-layers-intersect fs-1 text-info mb-3 d-block"></i>
                            <div class="fw-black h2 text-white mb-1"><?php echo e($sections->total()); ?></div>
                            <small class="text-white opacity-30 fw-bold text-uppercase tracking-widest" style="font-size: 0.6rem;">Total Phases</small>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="glass-widget text-center border-primary border-opacity-20">
                            <i class="ti ti-database-cog fs-1 text-primary mb-3 d-block"></i>
                            <div class="fw-black h2 text-primary text-ltr mb-1">ACTIVE</div>
                            <small class="text-white opacity-30 fw-bold text-uppercase tracking-widest" style="font-size: 0.6rem;">Status Layer</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mb-5 reveal-up" style="animation-delay: 0.1s">
        <div class="col-md-5">
            <div class="position-relative h-100">
                <i class="ti ti-search position-absolute top-50 start-0 translate-middle-y ms-4 text-primary fs-4"></i>
                <input type="text" wire:model.live.debounce.400ms="search" class="form-control crystal-input ps-5 h-100 border-0 shadow-sm" placeholder="جستجوی هوشمند در شناسه، نام یا فاز...">
            </div>
        </div>
        <div class="col-md-7 d-flex justify-content-md-end gap-3 align-items-center">
            <div class="btn-group bg-white p-1 rounded-4 shadow-sm border border-light">
                <button class="btn border-0 rounded-3 px-3 <?php echo e($viewType === 'card' ? 'bg-primary text-white shadow-sm' : 'text-muted'); ?>" wire:click="$set('viewType', 'card')"><i class="ti ti-layout-grid fs-5"></i></button>
                <button class="btn border-0 rounded-3 px-3 <?php echo e($viewType === 'list' ? 'bg-primary text-white shadow-sm' : 'text-muted'); ?>" wire:click="$set('viewType', 'list')"><i class="ti ti-list fs-5"></i></button>
            </div>
            <button class="btn btn-neon d-flex align-items-center gap-3 px-5 shadow-primary" data-bs-toggle="modal" data-bs-target="#addSectionModal" wire:click="resetForms">
                <i class="ti ti-circle-plus fs-4"></i>
                <span>افزودن لایه جدید</span>
            </button>
        </div>
    </div>

    <div class="position-relative" wire:loading.class="opacity-50">
        <?php if($viewType === 'card'): ?>
            <div class="row g-4">
                <?php $__empty_1 = true; $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-xl-4 col-md-6 reveal-up" wire:key="sec-grid-<?php echo e($section->id); ?>">
                        <div class="bento-item h-100 shadow-sm">
                            <div class="d-flex justify-content-between mb-4 align-items-start">
                                <div class="icon-box-lux shadow-sm">
                                    <i class="ti ti-folders fs-3"></i>
                                </div>
                                <div class="dropdown">
                                    <button class="btn btn-light rounded-circle shadow-none p-2 border-0" data-bs-toggle="dropdown"><i class="ti ti-dots-vertical fs-5"></i></button>
                                    <ul class="dropdown-menu dropdown-menu-end border-0 shadow-lg rounded-4 p-2">
                                        <li><a class="dropdown-item rounded-3 py-2 fw-bold text-primary" href="<?php echo e(route('admin.sections.files', $section->id)); ?>" wire:navigate><i class="ti ti-folder-open me-2"></i> مدیریت اسناد</a></li>
                                        <li><hr class="dropdown-divider opacity-50"></li>
                                        <li><button class="dropdown-item rounded-3 py-2 fw-bold" wire:click="editSection(<?php echo e($section->id); ?>)"><i class="ti ti-edit me-2"></i> ویرایش شناسنامه</button></li>
                                        <li><button class="dropdown-item rounded-3 py-2 fw-bold text-danger" wire:click="deleteSection(<?php echo e($section->id); ?>)" wire:confirm="آیا از پاکسازی دائمی اطمینان دارید؟"><i class="ti ti-trash me-2"></i> حذف دائمی</button></li>
                                    </ul>
                                </div>
                            </div>

                            <a href="<?php echo e(route('admin.sections.files', $section->id)); ?>" class="text-decoration-none" wire:navigate>
                                <h4 class="fw-black text-dark mb-2 hover-text-primary fs-4"><?php echo e($section->name); ?></h4>
                            </a>
                            <p class="text-muted small line-clamp-2 mb-4 fw-medium opacity-75"><?php echo e($section->description ?? 'توضیحات فنی برای این لایه ثبت نشده است.'); ?></p>

                            <div class="mt-auto pt-4 border-top d-flex justify-content-between align-items-center">
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-2 fw-black small"><i class="ti ti-files me-1"></i> <?php echo e($section->files_count ?? 0); ?> مستند</span>
                                    <span class="badge bg-success-subtle text-success rounded-pill px-3 py-2 fw-bold small">ACTIVE</span>
                                </div>
                                <small class="text-muted fw-bold" style="font-size: 0.65rem;"><?php echo e(jdate($section->created_at)->format('Y/m/d')); ?></small>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12 text-center py-5 opacity-20">
                        <i class="ti ti-layers-subtract fs-1 d-block mb-3" style="font-size: 6rem !important;"></i>
                        <h4 class="fw-black">ساختار لایه‌ای پروژه تعریف نشده است</h4>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="elite-bento-card overflow-hidden reveal-up">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light-subtle border-bottom">
                        <tr>
                            <th class="py-4 ps-5 fw-black text-muted small text-uppercase tracking-widest">IDENTIFIER</th>
                            <th class="py-4 fw-black text-muted small text-uppercase">SPECIFICATIONS</th>
                            <th class="py-4 text-center fw-black text-muted small text-uppercase">ANALYTICS</th>
                            <th class="py-4 text-center fw-black text-muted small text-uppercase pe-5">ACTIONS</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr wire:key="sec-list-<?php echo e($section->id); ?>">
                                <td class="ps-5 py-4">
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="icon-box-lux" style="width: 45px; height: 45px;"><i class="ti ti-folder fs-4"></i></div>
                                        <a href="<?php echo e(route('admin.sections.files', $section->id)); ?>" class="text-decoration-none text-dark fw-black fs-6" wire:navigate><?php echo e($section->name); ?></a>
                                    </div>
                                </td>
                                <td><span class="text-muted small fw-medium line-clamp-1 opacity-75"><?php echo e($section->description ?? '-'); ?></span></td>
                                <td class="text-center"><span class="badge bg-light text-primary fw-black rounded-pill px-3 py-2 shadow-sm border"><?php echo e($section->files_count ?? 0); ?> Assets</span></td>
                                <td class="text-center pe-5">
                                    <div class="d-flex justify-content-center gap-2">
                                        <button wire:click="editSection(<?php echo e($section->id); ?>)" class="btn btn-sm btn-white border shadow-xs rounded-3 p-2 text-primary hover-lift"><i class="ti ti-edit fs-5"></i></button>
                                        <button wire:click="deleteSection(<?php echo e($section->id); ?>)" class="btn btn-sm btn-white border shadow-xs rounded-3 p-2 text-danger hover-lift" wire:confirm="حذف دائمی؟"><i class="ti ti-trash fs-5"></i></button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php endif; ?>

        <div class="mt-5 d-flex justify-content-center">
            <?php echo e($sections->links('livewire::bootstrap')); ?>

        </div>
    </div>

    <div class="modal fade" id="addSectionModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <form wire:submit.prevent="createSection" class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden">
                <div class="modal-header border-0 bg-slate text-white p-4">
                    <h4 class="fw-black m-0">ایجاد فاز عملیاتی جدید</h4>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" wire:click="resetForms"></button>
                </div>
                <div class="modal-body p-5">
                    <div class="mb-4">
                        <label class="form-label fw-bold text-dark small mb-2 ms-2 opacity-50 text-uppercase tracking-wider">Name / شناسنامه بخش</label>
                        <input type="text" wire:model.defer="new_section_name" class="form-control crystal-input <?php $__errorArgs = ['new_section_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" placeholder="مثلاً: فاز اول معماری">
                        <?php $__errorArgs = ['new_section_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback fw-bold mt-2 ps-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="form-label fw-bold text-dark small mb-2 ms-2 opacity-50 text-uppercase tracking-wider">Description / توضیحات</label>
                        <textarea wire:model.defer="new_section_description" class="form-control crystal-input" rows="4" placeholder="خلاصه‌ای از جزئیات این بخش..."></textarea>
                    </div>
                </div>
                <div class="modal-footer border-0 p-4">
                    <button type="button" class="btn btn-light rounded-pill px-4 fw-bold flex-grow-1 py-3" data-bs-dismiss="modal" wire:click="resetForms">انصراف</button>
                    <button type="submit" class="btn btn-neon px-5 flex-grow-1 py-3">تایید و ثبت نهایی</button>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="editSectionModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <form wire:submit.prevent="updateSection" class="modal-content border-0 shadow-2xl rounded-5 overflow-hidden">
                <div class="modal-header border-0 bg-slate text-white p-4">
                    <h4 class="fw-black m-0">ویرایش شناسنامه لایه</h4>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" wire:click="resetForms"></button>
                </div>
                <div class="modal-body p-5">
                    <div class="mb-4">
                        <label class="form-label fw-bold text-dark small mb-2 ms-2 opacity-50 text-uppercase tracking-wider">Update Name / نام بخش</label>
                        <input type="text" wire:model.defer="edit_section_name" class="form-control crystal-input <?php $__errorArgs = ['edit_section_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        <?php $__errorArgs = ['edit_section_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback fw-bold mt-2 ps-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="form-label fw-bold text-dark small mb-2 ms-2 opacity-50 text-uppercase tracking-wider">Update Metadata / توضیحات</label>
                        <textarea wire:model.defer="edit_section_description" class="form-control crystal-input" rows="4"></textarea>
                    </div>
                </div>
                <div class="modal-footer border-0 p-4">
                    <button type="button" class="btn btn-light rounded-pill px-4 fw-bold flex-grow-1 py-3" data-bs-dismiss="modal" wire:click="resetForms">انصراف</button>
                    <button type="submit" class="btn btn-lux-action px-5 flex-grow-1 py-3 shadow-primary">ذخیره تغییرات</button>
                </div>
            </form>
        </div>
    </div>



    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('close-add-section-modal', () => {
                bootstrap.Modal.getInstance(document.getElementById('addSectionModal')).hide();
            });
            Livewire.on('open-edit-section-modal', () => {
                new bootstrap.Modal(document.getElementById('editSectionModal')).show();
            });
            Livewire.on('close-edit-section-modal', () => {
                bootstrap.Modal.getInstance(document.getElementById('editSectionModal')).hide();
            });
        });
    </script>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-section.blade.php ENDPATH**/ ?>