<div class="container-fluid py-4">
    <div class="row g-4 mb-5">
        <div class="col-6 col-xl-3">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden position-relative hover-translate-top transition-all">
                <div class="card-body p-4 bg-gradient-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1 opacity-75 fw-bold small">کل درخواست‌ها</h6>
                            <h3 class="fw-black mb-0 fs-3"><?php echo e($myRequests->total()); ?></h3>
                        </div>
                        <div class="icon-shape bg-white bg-opacity-20 rounded-3 p-3">
                            <i class="ti ti-stack-2 fs-2 text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-xl-3">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden position-relative hover-translate-top transition-all text-white">
                <div class="card-body p-4 bg-gradient-warning">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1 opacity-75 fw-bold small">در جریان تایید</h6>
                            <h3 class="fw-black mb-0 fs-3"><?php echo e($this->stats['pending'] ?? 0); ?></h3>
                        </div>
                        <div class="icon-shape bg-white bg-opacity-20 rounded-3 p-3">
                            <i class="ti ti-loader-2 fs-2 animate-spin"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-xl-3">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden position-relative hover-translate-top transition-all text-white">
                <div class="card-body p-4 bg-gradient-success">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1 opacity-75 fw-bold small">خرید نهایی</h6>
                            <h3 class="fw-black mb-0 fs-3"><?php echo e($this->stats['approved'] ?? 0); ?></h3>
                        </div>
                        <div class="icon-shape bg-white bg-opacity-20 rounded-3 p-3">
                            <i class="ti ti-circle-check fs-2"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-6 col-xl-3">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden position-relative hover-translate-top transition-all text-white">
                <div class="card-body p-4 bg-gradient-dark">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="mb-1 opacity-75 fw-bold small">ارزش کل (م. ریال)</h6>
                            <h3 class="fw-black mb-0 fs-4"><?php echo e(number_format(($this->stats['total_budget'] ?? 0) / 1000000, 1)); ?></h3>
                        </div>
                        <div class="icon-shape bg-white bg-opacity-20 rounded-3 p-3">
                            <i class="ti ti-cash fs-2 text-white"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-end mb-4 gap-4 px-2">
        <div>
            <h2 class="fw-black text-dark mb-1 letter-spacing-tight">پنل تدارکات من</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 small fw-bold">
                    <li class="breadcrumb-item text-muted">داشبورد</li>
                    <li class="breadcrumb-item text-primary active">درخواست‌های خرید</li>
                </ol>
            </nav>
        </div>

        <div class="d-flex gap-3 align-items-center bg-white p-2 rounded-4 shadow-sm border border-light">
            <div class="btn-group p-1 bg-light rounded-3">
                <button class="btn btn-sm btn-icon <?php echo e($viewMode == 'grid' ? 'bg-white shadow-sm fw-black' : 'text-muted border-0'); ?> transition-all" wire:click="setViewMode('grid')"><i class="ti ti-layout-grid"></i></button>
                <button class="btn btn-sm btn-icon <?php echo e($viewMode == 'table' ? 'bg-white shadow-sm fw-black' : 'text-muted border-0'); ?> transition-all" wire:click="setViewMode('table')"><i class="ti ti-list"></i></button>
            </div>
            <div class="vr h-50 my-auto text-secondary opacity-25"></div>
            <a href="<?php echo e(route('admin.purchase_request')); ?>" class="btn btn-primary rounded-pill px-4 fw-black shadow-primary py-2 hover-scale">
                <i class="ti ti-plus me-1"></i> درخواست جدید
            </a>
        </div>
    </div>

    <div class="card border-0 shadow-sm rounded-4 mb-5 bg-white border border-light overflow-hidden">
        <div class="card-body p-3">
            <div class="row g-2 align-items-center">
                <div class="col-md-5">
                    <div class="input-group input-group-merge bg-light rounded-3 border-0">
                        <span class="input-group-text bg-transparent border-0 ps-3"><i class="ti ti-search text-muted"></i></span>
                        <input type="text" class="form-control bg-transparent border-0 ps-1 py-2 fw-medium" wire:model.live.debounce.400ms="search" placeholder="جستجو بر اساس کد، کالا یا پروژه...">
                    </div>
                </div>
                <div class="col-md-2">
                    <select class="form-select bg-light border-0 rounded-3 py-2 fw-bold small shadow-none" wire:model.live="statusFilter">
                        <option value="">همه وضعیت‌ها</option>
                        <option value="pending">⏳ در انتظار</option>
                        <option value="approved">✅ تایید شده</option>
                        <option value="rejected">❌ رد شده</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <select class="form-select bg-light border-0 rounded-3 py-2 fw-bold small shadow-none" wire:model.live="projectFilter">
                        <option value="">تمامی پروژه‌ها</option>
                        <?php $__currentLoopData = $this->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-outline-danger w-100 rounded-3 border-0 py-2 fw-black small bg-danger bg-opacity-10" wire:click="resetFilters">
                        <i class="ti ti-refresh me-1"></i> بازنشانی
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div wire:loading.class="opacity-50 blur-sm" class="transition-base">
        <?php if($myRequests->isEmpty()): ?>
            <div class="card border-0 shadow-sm rounded-5 text-center py-5 bg-white border border-light">
                <div class="card-body">
                    <img src="https://cdn-icons-png.flaticon.com/512/7486/7486744.png" width="120" class="mb-4 opacity-25 grayscale">
                    <h5 class="text-dark fw-black">موردی برای نمایش یافت نشد!</h5>
                    <p class="text-muted small px-5">معیارهای جستجو را تغییر دهید یا درخواست جدیدی ثبت کنید.</p>
                </div>
            </div>
        <?php else: ?>
            <?php if($viewMode == 'grid'): ?>
                <div class="row g-4">
                    <?php $__currentLoopData = $myRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $status = match($req->status) {
                                'approved' => ['bg' => 'success', 'icon' => 'ti-circle-check', 'label' => 'تأیید نهایی'],
                                'rejected' => ['bg' => 'danger', 'icon' => 'ti-circle-x', 'label' => 'رد شده'],
                                default => ['bg' => 'primary', 'icon' => 'ti-clock-play', 'label' => 'در جریان'],
                            };
                            $approvedCount = $req->approvals->where('is_approved', true)->count();
                            $total = $req->approvals->count();
                            $percent = $total > 0 ? intval(($approvedCount / $total) * 100) : 0;
                        ?>
                        <div class="col-xl-4 col-md-6">
                            <div class="card h-100 border-0 shadow-sm rounded-4 card-purchase overflow-hidden transition-all bg-white border border-light">
                                <div class="bg-<?php echo e($status['bg']); ?> opacity-75" style="height: 4px;"></div>
                                <div class="card-body p-4">
                                    <div class="d-flex justify-content-between mb-4 align-items-start">
                                        <div class="badge bg-<?php echo e($status['bg']); ?> bg-opacity-10 text-<?php echo e($status['bg']); ?> px-3 py-2 rounded-3 border-0 small fw-black">
                                            <i class="ti <?php echo e($status['icon']); ?> me-1"></i> <?php echo e($status['label']); ?>

                                        </div>
                                        <div class="text-muted fw-black small letter-spacing-1 bg-light px-2 py-1 rounded">#<?php echo e($req->id); ?></div>
                                    </div>

                                    <h5 class="fw-black mb-2 text-dark text-truncate letter-spacing-tight"><?php echo e($req->project->name); ?></h5>
                                    <p class="text-muted small mb-4 line-clamp-2" style="min-height: 2.8em;"><?php echo e($req->description); ?></p>

                                    <div class="bg-light bg-opacity-50 p-3 rounded-4 mb-4 border border-white shadow-xs">
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <span class="small text-secondary fw-bold">بودجه برآوردی:</span>
                                            <span class="fw-black text-dark fs-5"><?php echo e(number_format($req->total_price)); ?> <small class="fw-bold fs-6 text-muted">ریال</small></span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-1 mt-3">
                                            <span class="small fw-black text-muted">تاییدات سیستمی</span>
                                            <span class="small fw-black text-<?php echo e($status['bg']); ?>"><?php echo e($percent); ?>%</span>
                                        </div>
                                        <div class="progress rounded-pill bg-white shadow-xs" style="height: 6px;">
                                            <div class="progress-bar bg-<?php echo e($status['bg']); ?> rounded-pill" style="width: <?php echo e($percent); ?>%"></div>
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center pt-2 mt-auto">
                                        <div class="text-muted small fw-black d-flex align-items-center">
                                            <i class="ti ti-calendar-event me-1 fs-5 text-primary"></i><?php echo e(jdate($req->created_at)->format('Y/m/d')); ?>

                                        </div>
                                        <div class="d-flex gap-2">
                                            <button class="btn btn-icon btn-dark rounded-3 shadow-sm hover-scale" data-bs-toggle="modal" data-bs-target="#detailModal<?php echo e($req->id); ?>">
                                                <i class="ti ti-eye"></i>
                                            </button>
                                            <?php if($req->status == 'pending'): ?>
                                                <button class="btn btn-icon btn-light-danger rounded-3 shadow-sm hover-scale" wire:click="deleteRequest(<?php echo e($req->id); ?>)" onclick="return confirm('حذف شود؟')">
                                                    <i class="ti ti-trash"></i>
                                                </button>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="card border-0 shadow-sm rounded-4 overflow-hidden bg-white border border-light">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light text-dark">
                            <tr>
                                <th class="py-4 ps-4 fw-black border-0">کد پرونده</th>
                                <th class="py-4 border-0 fw-black">پروژه</th>
                                <th class="py-4 border-0 fw-black">مبلغ نهایی (ریال)</th>
                                <th class="py-4 border-0 text-center fw-black">وضعیت خرید</th>
                                <th class="py-4 border-0 text-end pe-4 fw-black">مشاهده</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $myRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="transition-all">
                                    <td class="ps-4 fw-black text-primary small">#<?php echo e($req->id); ?></td>
                                    <td class="fw-bold"><?php echo e($req->project->name); ?></td>
                                    <td class="fw-black text-success"><?php echo e(number_format($req->total_price)); ?></td>
                                    <td class="text-center">
                                        <span class="badge bg-light text-dark rounded-pill px-3 border fw-black small shadow-xs"><?php echo e($req->status); ?></span>
                                    </td>
                                    <td class="text-end pe-4">
                                        <button class="btn btn-sm btn-icon btn-light rounded-3 text-primary shadow-xs" data-bs-toggle="modal" data-bs-target="#detailModal<?php echo e($req->id); ?>"><i class="ti ti-eye"></i></button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
            <div class="d-flex justify-content-center mt-5">
                <?php echo e($myRequests->links()); ?>

            </div>
        <?php endif; ?>
    </div>

    <?php $__currentLoopData = $myRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="detailModal<?php echo e($req->id); ?>" tabindex="-1" aria-hidden="true" wire:ignore.self>
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content shadow-2xl border-0 rounded-5 overflow-hidden">
                    <div class="modal-header bg-dark text-white py-4 border-0 px-4">
                        <div class="d-flex align-items-center">
                            <div class="bg-primary p-2 rounded-3 me-3 shadow-primary">
                                <i class="ti ti-file-analytics fs-3"></i>
                            </div>
                            <div>
                                <h5 class="modal-title fw-black mb-0">پرونده الکترونیک PR-<?php echo e($req->id); ?></h5>
                                <small class="opacity-50 fw-bold">مدیریت هوشمند درخواست‌های تدارکاتی</small>
                            </div>
                        </div>
                        <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body p-0 bg-light-subtle">
                        <div class="p-4 bg-white border-bottom shadow-sm mx-3 mt-3 rounded-4 border border-light">
                            <div class="row g-4 align-items-center">
                                <div class="col-md-3">
                                    <small class="text-muted d-block mb-1 fw-bold fs-xs">پروژه مقصد</small>
                                    <span class="fw-black text-dark fs-6"><?php echo e($req->project->name); ?></span>
                                </div>
                                <div class="col-md-3 border-start-md ps-md-4">
                                    <small class="text-muted d-block mb-1 fw-bold fs-xs">نوع درخواست</small>
                                    <span class="badge bg-primary-subtle text-primary rounded-pill px-3 fw-black"><?php echo e(['material' => 'کالا', 'service' => 'خدمات', 'asset' => 'دارایی'][$req->purchase_type] ?? 'نامشخص'); ?></span>
                                </div>
                                <div class="col-md-3 border-start-md ps-md-4">
                                    <small class="text-muted d-block mb-1 fw-bold fs-xs">تاریخ اولویت نیاز</small>
                                    <span class="fw-black text-danger"><?php echo e($req->required_by ? jdate($req->required_by)->format('Y/m/d') : '---'); ?></span>
                                </div>
                                <div class="col-md-3 border-start-md text-end">
                                    <a href="<?php echo e(route('purchase.download', $req->id)); ?>" target="_blank" class="btn btn-danger rounded-pill px-4 fw-black shadow-sm transition-all hover-scale">
                                        <i class="ti ti-file-type-pdf me-1"></i> خروجی PDF
                                    </a>
                                </div>
                            </div>
                        </div>

                        <div class="accordion accordion-flush p-3" id="purchaseAccordion<?php echo e($req->id); ?>">
                            <div class="accordion-item rounded-4 mb-3 border-0 shadow-xs overflow-hidden">
                                <h2 class="accordion-header">
                                    <button class="accordion-button fw-black py-4 px-4 bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#desc<?php echo e($req->id); ?>">
                                        <span class="icon-circle bg-primary-subtle text-primary me-3"><i class="ti ti-message-2"></i></span>
                                        ۱. شرح و ضرورت تامین
                                    </button>
                                </h2>
                                <div id="desc<?php echo e($req->id); ?>" class="accordion-collapse collapse show" data-bs-parent="#purchaseAccordion<?php echo e($req->id); ?>">
                                    <div class="accordion-body bg-white pt-0 px-5 pb-4 leading-relaxed text-dark fw-medium opacity-75">
                                        <?php echo e($req->description); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item rounded-4 mb-3 border-0 shadow-xs overflow-hidden">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed fw-black py-4 px-4 bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#items<?php echo e($req->id); ?>">
                                        <span class="icon-circle bg-success-subtle text-success me-3"><i class="ti ti-box"></i></span>
                                        ۲. ریز اقلام کالا و خدمات فنی
                                    </button>
                                </h2>
                                <div id="items<?php echo e($req->id); ?>" class="accordion-collapse collapse" data-bs-parent="#purchaseAccordion<?php echo e($req->id); ?>">
                                    <div class="accordion-body p-0 border-top">
                                        <div class="table-responsive">
                                            <table class="table table-hover align-middle mb-0">
                                                <thead class="bg-light text-muted small fw-black text-center">
                                                <tr>
                                                    <th class="py-3 ps-4">ردیف</th>
                                                    <th class="py-3 text-end">شرح قلم</th>
                                                    <th class="py-3">تعداد</th>
                                                    <th class="py-3">برآورد واحد (ریال)</th>
                                                    <th class="py-3 text-end pe-4">جمع کل</th>
                                                </tr>
                                                </thead>
                                                <tbody class="text-center">
                                                <?php $__currentLoopData = $req->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class="ps-4 text-muted small"><?php echo e($idx + 1); ?></td>
                                                        <td class="text-end fw-bold"><?php echo e($item->displayName); ?></td>
                                                        <td class="fw-black"><?php echo e($item->quantity); ?></td>
                                                        <td class="text-muted small"><?php echo e(number_format($item->price)); ?></td>
                                                        <td class="text-end pe-4 fw-black text-success"><?php echo e(number_format($item->subtotal)); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                                <tfoot class="bg-dark text-white fw-black border-0">
                                                <tr>
                                                    <td colspan="4" class="text-end py-4 border-0">جمع نهایی برآورد پرونده (ریال):</td>
                                                    <td class="text-end pe-4 py-4 fs-5 border-0"><?php echo e(number_format($req->total_price)); ?></td>
                                                </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item rounded-4 border-0 shadow-xs overflow-hidden">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed fw-black py-4 px-4 bg-white" type="button" data-bs-toggle="collapse" data-bs-target="#workflow<?php echo e($req->id); ?>">
                                        <span class="icon-circle bg-warning-subtle text-warning me-3"><i class="ti ti-git-fork"></i></span>
                                        ۳. تاریخچه گردش کار و تاییدات مدیران
                                    </button>
                                </h2>
                                <div id="workflow<?php echo e($req->id); ?>" class="accordion-collapse collapse" data-bs-parent="#purchaseAccordion<?php echo e($req->id); ?>">
                                    <div class="accordion-body bg-white p-4 border-top">
                                        <div class="row g-3">
                                            <?php $__currentLoopData = $req->approvals->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $appr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-4">
                                                    <div class="card h-100 rounded-4 border-start border-4 border-<?php echo e($appr->is_approved === true ? 'success' : ($appr->is_approved === false ? 'danger' : 'secondary')); ?> bg-light border-top-0 border-end-0 border-bottom-0 shadow-xs transition-all hover-translate-top">
                                                        <div class="card-body p-3">
                                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                                <span class="fw-black small text-muted"><?php echo e($appr->role->name); ?></span>
                                                                <span class="badge <?php echo e($appr->is_approved === true ? 'bg-success' : ($appr->is_approved === false ? 'bg-danger' : 'bg-secondary')); ?> rounded-pill small px-2">
                                                                    <?php echo e($appr->is_approved === true ? 'تایید شد' : ($appr->is_approved === false ? 'رد شد' : 'در انتظار')); ?>

                                                                </span>
                                                            </div>
                                                            <h6 class="fw-black mb-1 fs-xs"><?php echo e($appr->user->name ?? '---'); ?></h6>
                                                            <small class="text-muted fs-xs"><i class="ti ti-clock me-1"></i><?php echo e($appr->approved_at ? jdate($appr->approved_at)->format('Y/m/d H:i') : 'بدون اقدام'); ?></small>
                                                            <?php if($appr->comment): ?>
                                                                <div class="mt-3 p-2 bg-white rounded-3 small border-0 italic text-secondary shadow-xs">
                                                                    "<?php echo e($appr->comment); ?>"
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer bg-white justify-content-center py-4 border-0">
                        <button type="button" class="btn btn-secondary rounded-pill px-5 fw-black shadow-sm" data-bs-dismiss="modal">بستن پرونده</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <style>

        .fw-black { font-weight: 900 !important; }
        .fs-xs { font-size: 0.75rem !important; }
        .bg-gradient-primary { background: linear-gradient(135deg, #0d6efd 0%, #0043a8 100%); }
        .bg-gradient-warning { background: linear-gradient(135deg, #ffc107 0%, #d39e00 100%); }
        .bg-gradient-success { background: linear-gradient(135deg, #198754 0%, #0f5132 100%); }
        .bg-gradient-dark { background: linear-gradient(135deg, #212529 0%, #000000 100%); }

        .transition-all { transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); }
        .hover-scale:hover { transform: scale(1.05); }
        .hover-translate-top:hover { transform: translateY(-8px); }
        .blur-sm { filter: blur(2px); }

        .card-purchase { border: 1px solid #f1f5f9; cursor: default; }
        .card-purchase:hover { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.12) !important; }

        .icon-circle { width: 35px; height: 35px; border-radius: 10px; display: inline-flex; align-items: center; justify-content: center; font-size: 1.1rem; }
        .shadow-xs { box-shadow: 0 2px 4px rgba(0,0,0,0.02) !important; }
        .shadow-2xl { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important; }
        .shadow-primary { box-shadow: 0 10px 15px -3px rgba(13, 110, 253, 0.3) !important; }

        .accordion-button:not(.collapsed) {
            box-shadow: none;
            border-bottom: 2px solid #f8f9fa;
        }
        .accordion-button::after { background-size: 1rem; }

        .btn-icon { width: 36px; height: 36px; display: flex; align-items: center; justify-content: center; }
        .animate-spin { animation: spin 2s linear infinite; }
        @keyframes spin { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }

        @media (min-width: 768px) { .border-start-md { border-right: 1px solid #f1f5f9 !important; } }
        .line-clamp-2 { display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; }
        .letter-spacing-tight { letter-spacing: -0.5px; }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\my-purchase-requests.blade.php ENDPATH**/ ?>