<div class="container py-4">

    
    <?php if(session()->has('success')): ?>
        <div
            class="alert alert-success alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center success-alert-custom">
            <i class="ti ti-check-circle me-2 fs-5"></i>
            <span class="fw-semibold"><?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    <?php endif; ?>

    <?php if(session()->has('error')): ?>
        <div
            class="alert alert-danger alert-dismissible fade show rounded-3 shadow-sm mb-4 d-flex align-items-center danger-alert-custom">
            <i class="ti ti-alert-triangle me-2 fs-5"></i>
            <span class="fw-semibold"><?php echo e(session('error')); ?></span>
            <button type="button" class="btn-close ms-auto" data-bs-dismiss="alert" aria-label="بستن"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-2xl border-0 rounded-4">
        <div class="card-header bg-primary-header text-white p-4">
            <h5 class="card-title mb-0 fw-bold d-flex align-items-center">
                <i class="ti ti-user-plus me-2 fs-4 text-warning-contrast"></i> تعیین سمت سازمانی کاربر
            </h5>
        </div>
        <div class="card-body p-5">
            <form wire:submit.prevent="saveUserPosition">

                <h6 class="fw-bold text-dark-primary mb-4 border-bottom pb-3"><i
                        class="ti ti-search me-2 text-action-primary"></i> گام ۱: انتخاب کاربر</h6>

                
                <div class="row g-3 mb-4">
                    <div class="col-md-6">
                        <label class="form-label text-dark-primary small">فیلتر شرکت</label>
                        <select wire:model.live="companyIdFilter" class="form-select rounded-pill shadow-input">
                            <option value="">— همه شرکت‌ها —</option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label text-dark-primary small">فیلتر دپارتمان</label>
                        <select wire:model.live="departmentIdFilter" class="form-select rounded-pill shadow-input"
                            <?php if(!$companies->count() || !$companyIdFilter): echo 'disabled'; endif; ?>>
                            <option value="">— همه دپارتمان‌ها —</option>
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($dept->id); ?>"><?php echo e($dept->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                
                <div class="mb-4 position-relative" x-data="{ isSearching: false }"
                     x-on:focusin="isSearching = true"
                     x-on:click.away.debounce.100ms="isSearching = false"
                >
                    <label for="user_search" class="form-label text-dark-primary">جستجو و انتخاب کاربر:</label>
                    <div class="input-group input-group-lg rounded-pill shadow-input">
                        <span class="input-group-text"><i class="ti ti-user"></i></span>
                        <input
                            type="text"
                            id="user_search"
                            wire:model.live.debounce.300ms="searchTerm"
                            x-on:focus="isSearching = true"
                            class="form-control <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            placeholder="نام یا ایمیل کاربر را تایپ کنید..."
                            <?php if($isUserSelected): echo 'disabled'; endif; ?>
                        />
                        <?php if($isUserSelected): ?>
                            <button type="button" wire:click="resetFields" class="btn btn-clean-danger" title="حذف انتخاب">
                                <i class="ti ti-x"></i></button>
                        <?php endif; ?>
                    </div>
                    <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    
                    <?php if(!$isUserSelected): ?>
                        <div x-show="isSearching"
                             class="search-results-box rounded-3xl p-3 shadow-lg transition"
                             style="display: none;"
                        >
                            <?php $__empty_1 = true; $__currentLoopData = $filteredUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div wire:click="selectUser(<?php echo e($user->id); ?>)"
                                     class="d-flex align-items-center justify-content-between p-2 hover-bg-light rounded-2xl cursor-pointer mb-1 transition">
                                    <div class="d-flex align-items-center gap-3">
                                        
                                        <img
                                            src="<?php echo e($user->image ? asset('storage/' . $user->image) : asset('user-default.svg')); ?>"
                                            class="rounded-circle user-avatar" width="35" height="35" alt="<?php echo e($user->name); ?>">
                                        <div>
                                            <div class="fw-semibold text-dark-primary"><?php echo e($user->name); ?></div>
                                            <div class="small text-muted"><?php echo e($user->email); ?></div>
                                        </div>
                                    </div>
                                    <span class="badge bg-soft-primary text-primary">انتخاب</span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted small py-3 mb-0">
                                    نتایج دیگری یافت نشد.
                                </p>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>


                
                <?php if($selectedUserObject): ?>
                    <div
                        class="user-confirmation-box p-4 rounded-4 bg-primary-light border border-action-primary mb-5 shadow-md">
                        <h6 class="fw-bold text-dark-primary mb-3"><i class="ti ti-user-check me-1 text-action-primary"></i>
                            کاربر انتخاب شده:</h6>
                        <div class="d-flex align-items-center gap-4">
                            <img
                                src="<?php echo e($selectedUserObject->image ? asset('storage/' . $selectedUserObject->image) : asset('user-default.svg')); ?>"
                                class="rounded-circle user-avatar-large border-white" width="60" height="60"
                                alt="<?php echo e($selectedUserObject->name); ?>">
                            <div>
                                <h4 class="mb-0 text-dark-primary fw-bolder"><?php echo e($selectedUserObject->name); ?></h4>
                                <span class="text-secondary-light small"><?php echo e($selectedUserObject->email); ?></span>
                                <div class="small text-muted mt-1">
                                    <?php if($selectedUserObject->department): ?>
                                        <?php echo e($selectedUserObject->department->name); ?> (<?php echo e($selectedUserObject->department->company->name ?? '---'); ?>)
                                    <?php else: ?>
                                        بدون ساختار سازمانی
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <h6 class="fw-bold text-dark-primary mb-4 border-bottom pb-3"><i
                        class="ti ti-briefcase me-2 text-warning"></i> گام ۲: تعیین سمت</h6>

                
                <div class="mb-5">
                    <label for="position" class="form-label text-dark-primary">سمت سازمانی <span
                            class="text-danger">*</span></label>
                    <input
                        type="text"
                        id="position"
                        wire:model.defer="position"
                        class="form-control rounded-pill <?php $__errorArgs = ['position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        placeholder="مثلاً: مدیر پروژه، کارشناس مالی"
                        <?php if(!$isUserSelected): echo 'disabled'; endif; ?>
                    />
                    <?php $__errorArgs = ['position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="text-danger small mt-1"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="d-flex justify-content-end border-top pt-4">
                    <button type="submit"
                            class="btn btn-action-primary px-5 py-2 fw-bold rounded-pill shadow-action-btn"
                        <?php if(!$isUserSelected): echo 'disabled'; endif; ?>>
                        <i class="ti ti-device-floppy me-2"></i> ذخیره سمت
                    </button>
                </div>
            </form>
        </div>
    </div>
    <style>
        :root {
            /* Palette Update: Deep Navy and Vibrant Blue */
            --primary-color: #3858FF; /* Vibrant Blue for action */
            --primary-dark: #1A2538; /* Deep Navy for Headers */
            --action-color: var(--primary-color);
            --primary-light: #EEF4FF; /* Soft background */
            --dark-primary: #1F2937; /* Main text */
            --secondary-light: #6B7280;
            --border-color: #E5E7EB;
            --shadow-action-btn: 0 6px 15px rgba(56, 88, 255, 0.4);
            --warning-color: #F59E0B;
            --success-color: #10B981;
            --danger-color: #EF4444;
            --warning-contrast: #FDE88F; /* Light Gold for header icon/text contrast */
        }

        .bg-primary-header {
            background: var(--primary-dark);
            color: white;
        }

        .header-fix-contrast .card-title,
        .header-fix-contrast .ti {
            color: white !important;
        }

        .header-fix-contrast .text-warning-contrast {
            color: var(--warning-contrast) !important;
        }

        .text-dark-primary {
            color: var(--dark-primary) !important;
        }

        .text-action-primary {
            color: var(--action-color) !important;
        }

        .bg-light-subtle-2 {
            background-color: #F9FAFB !important;
        }

        .bg-primary-light {
            background-color: var(--primary-light) !important;
        }

        .shadow-input {
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .shadow-action-btn {
            box-shadow: var(--shadow-action-btn);
        }

        .shadow-2xl {
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }

        /* Custom Shadow for Context Box */
        .shadow-inner-custom {
            box-shadow: inset 0 2px 4px 0 rgba(0, 0, 0, 0.06);
        }

        /* Forms */
        .form-control, .form-select {
            border-color: var(--border-color);
            padding: 0.75rem 1.25rem;
        }

        .form-control.rounded-pill, .form-select.rounded-pill {
            border-radius: 50rem !important;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--action-color);
            box-shadow: 0 0 0 3px rgba(56, 88, 255, 0.15); /* Stronger Focus Glow */
        }

        /* Search Input Group */
        .input-group-text {
            background-color: white;
            border-right: none;
            padding-left: 0.5rem;
            border-radius: 50rem 0 0 50rem !important;
            border-color: var(--border-color);
        }

        .input-group input {
            border-left: none;
            border-radius: 0 50rem 50rem 0 !important;
        }

        /* User Picker List */
        .search-results-box {
            position: absolute;
            width: 100%;
            max-height: 350px;
            overflow-y: auto;
            z-index: 20;
            top: 100%;
            left: 0;
            border: 1px solid #E5E7EB;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15);
            background-color: white;
            border-radius: 1rem;
            transform: translateY(4px);
        }

        .user-avatar {
            object-fit: cover;
            border: 2px solid var(--primary-light);
        }

        .user-avatar-large {
            object-fit: cover;
            border: 3px solid white;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .hover-bg-light:hover {
            background-color: var(--primary-light) !important;
            transform: scale(1.01);
        }

        /* Buttons */
        .btn-action-primary {
            background-color: var(--action-color) !important;
            border-color: var(--action-color) !important;
            color: white;
        }

        .btn-action-primary:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }

        .btn-clean-danger {
            color: var(--danger-color);
            border-color: var(--border-color);
            background-color: white;
            transition: all 0.2s;
        }

        .btn-clean-danger:hover {
            color: white;
            background-color: var(--danger-color);
            border-color: var(--danger-color);
        }

        /* Badges */
        .bg-soft-primary {
            background-color: var(--primary-light) !important;
            color: var(--primary-color) !important;
        }

        /* Alerts */
        .success-alert-custom {
            border-left: 5px solid var(--success-color);
        }

        .danger-alert-custom {
            border-left: 5px solid var(--danger-color);
        }

    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\users\positions\add-position.blade.php ENDPATH**/ ?>