<div wire:ignore.self class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-dark text-white" style="border-radius: 14px 14px 0 0;">
                <h5 class="modal-title" id="previewModalLabel">
                    <i class="fas fa-eye me-2"></i>
                    <?php echo e(__('پیش‌نمایش فایل')); ?> (آخرین رویژن)
                </h5>
                <button type="button" class="btn-close btn-close-white" wire:click="closePreviewModal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-0" style="min-height: 70vh;">
                <?php if($previewFileUrl): ?>
                    <?php
                        $isPdf = Str::endsWith($previewFileUrl, '.pdf');
                    ?>
                    <?php if($isPdf): ?>
                        <iframe src="<?php echo e($previewFileUrl); ?>" style="width: 100%; height: 70vh; border: none;"></iframe>
                    <?php else: ?>
                        <div class="text-center p-5">
                            <img src="<?php echo e($previewFileUrl); ?>" class="img-fluid rounded shadow" style="max-height: 70vh; max-width: 100%; object-fit: contain;" alt="<?php echo e(__('پیش‌نمایش تصویر')); ?>">
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="text-center py-5 text-muted">
                        <i class="fas fa-times-circle fa-3x mb-3"></i>
                        <p><?php echo e(__('فایل برای پیش‌نمایش آماده نیست یا فرمت آن پشتیبانی نمی‌شود (فقط PDF و Image).')); ?></p>
                    </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-modern" wire:click="closePreviewModal"><?php echo e(__('بستن')); ?></button>
            </div>
        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\modals\preview-modal.blade.php ENDPATH**/ ?>