<div>
    <div class="container-fluid dashboard-modern px-lg-4 py-4">

        
        <?php if($pendingProjects > 0): ?>
            <div class="alert alert-glass alert-warning mb-4 animate-fade-in" role="alert">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                        <div class="alert-icon-wrapper">
                            <i class="ti ti-alert-octagon"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="alert-heading mb-1 fw-bold">توجه به پروژه‌های در انتظار!</h6>
                        <p class="mb-0 fs-6"><span class="fw-bold"><?php echo e($pendingProjects); ?></span> پروژه نزدیک به مهلت تحویل هستند. لطفاً اقدام لازم را انجام دهید.</p>
                    </div>
                    <div class="flex-shrink-0">
                        <a href="<?php echo e(route('admin.projects')); ?>" class="btn btn-sm btn-warning-soft rounded-pill me-2">مشاهده</a>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        
        <div class="dashboard-header mb-5">
            <div class="row align-items-center g-4">
                <div class="col-lg-8">
                    <div class="welcome-section">
                        <div class="d-flex align-items-center">
                            <div class="avatar-wrapper me-3">
                                <img src="<?php echo e(asset('storage/' . auth()->user()->image)); ?>"

                                     alt="<?php echo e(auth()->user()->name); ?>"
                                     class="avatar-img-xl">
                                <span class="online-status-badge"></span>
                            </div>
                            <div>
                                <h1 class="fw-bolder mb-1">سلام، <span class="text-gradient-primary"><?php echo e(auth()->user()->name); ?></span> 👋</h1>
                                <p class="text-muted mb-0">
                                    <i class="ti ti-calendar me-1"></i>
                                    امروز <?php echo e(Verta::today()->format('l d F Y')); ?> است. روز خوبی داشته باشید!
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="quick-search-wrapper">
                        <div class="search-bar-glass">
                            <i class="ti ti-search search-icon"></i>
                            <input type="text" class="form-control-glass" placeholder="جستجوی پروژه، نامه، مخاطب...">
                            <button class="btn btn-primary btn-icon">
                                <i class="ti ti-arrow-right"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row g-4">

            
            <div class="col-xl-8">

                
                <div class="section-header mb-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="fw-bold mb-0"><i class="ti ti-chart-dots text-gradient-primary me-2"></i>آمار کلیدی</h2>
                            <p class="text-muted small mb-0">وضعیت کلی عملکرد شما</p>
                        </div>
                        <div class="time-filter">
                            <select class="form-select form-select-sm glass-select w-auto">
                                <option selected>امروز</option>
                                <option>هفته جاری</option>
                                <option>ماه جاری</option>
                                <option>کل سال</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row g-4 mb-5">
                    
                    <div class="col-md-6 col-lg-3">
                        <div class="metric-card card-hover">
                            <div class="metric-card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="metric-icon-wrapper bg-primary-soft">
                                        <i class="ti ti-folder text-primary"></i>
                                    </div>
                                    <span class="badge bg-primary-soft text-primary small"><?php echo e($pendingProjects); ?> در انتظار</span>
                                </div>
                                <h3 class="metric-value"><?php echo e($activeProjects); ?></h3>
                                <p class="metric-label">پروژه‌های فعال</p>
                                <div class="metric-progress mt-3">
                                    <div class="progress bg-primary-soft" style="height: 6px;">
                                        <div class="progress-bar bg-primary" style="width: <?php echo e(min(100, ($activeProjects / 20) * 100)); ?>%"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="metric-card-footer">
                                <a href="<?php echo e(route('admin.projects')); ?>" class="metric-link">
                                    <span>مشاهده جزئیات</span>
                                    <i class="ti ti-arrow-left"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-md-6 col-lg-3">
                        <div class="metric-card card-hover">
                            <div class="metric-card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="metric-icon-wrapper bg-success-soft">
                                        <i class="ti ti-inbox text-success"></i>
                                    </div>
                                    <?php if($newLetters > 0): ?>
                                        <span class="badge bg-danger-soft text-danger small pulse"><?php echo e($newLetters); ?> جدید</span>
                                    <?php endif; ?>
                                </div>
                                <h3 class="metric-value"><?php echo e($totalLetters); ?></h3>
                                <p class="metric-label">نامه‌های دریافتی</p>
                                <div class="metric-progress mt-3">
                                    <div class="progress bg-success-soft" style="height: 6px;">
                                        <div class="progress-bar bg-success" style="width: <?php echo e($totalLetters > 0 ? ($newLetters / $totalLetters) * 100 : 0); ?>%"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="metric-card-footer">
                                <a href="<?php echo e(route('letters.received')); ?>" class="metric-link">
                                    <span>مشاهده نامه‌ها</span>
                                    <i class="ti ti-arrow-left"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-md-6 col-lg-3">
                        <div class="metric-card card-hover">
                            <div class="metric-card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="metric-icon-wrapper bg-warning-soft">
                                        <i class="ti ti-send text-warning"></i>
                                    </div>
                                    <span class="badge bg-success-soft text-success small"><?php echo e($sentCompletedLetters); ?> تکمیل</span>
                                </div>
                                <h3 class="metric-value"><?php echo e($sentPendingLetters + $sentCompletedLetters); ?></h3>
                                <p class="metric-label">ارجاعات ارسالی</p>
                                <div class="metric-progress mt-3">
                                    <div class="progress bg-warning-soft" style="height: 6px;">
                                        <div class="progress-bar bg-warning" style="width: <?php echo e(($sentCompletedLetters / max(1, ($sentPendingLetters + $sentCompletedLetters))) * 100); ?>%"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="metric-card-footer">
                                <a href="<?php echo e(route('user.letter')); ?>" class="metric-link">
                                    <span>مدیریت ارجاعات</span>
                                    <i class="ti ti-arrow-left"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-md-6 col-lg-3">
                        <div class="metric-card card-hover">
                            <div class="metric-card-body">
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <div class="metric-icon-wrapper bg-info-soft">
                                        <i class="ti ti-files text-info"></i>
                                    </div>
                                    <span class="badge bg-info-soft text-info small">15 شخصی</span>
                                </div>
                                <h3 class="metric-value">98</h3>
                                <p class="metric-label">سند و مدرک</p>
                                <div class="metric-progress mt-3">
                                    <div class="progress bg-info-soft" style="height: 6px;">
                                        <div class="progress-bar bg-info" style="width: 65%"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="metric-card-footer">
                                <a href="#" class="metric-link">
                                    <span>مشاهده اسناد</span>
                                    <i class="ti ti-arrow-left"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="section-header mb-4">
                    <h2 class="fw-bold mb-0"><i class="ti ti-bolt text-gradient-warning me-2"></i>عملیات سریع</h2>
                    <p class="text-muted small mb-0">دسترسی سریع به امکانات پرکاربرد</p>
                </div>

                <div class="row g-3 mb-5">
                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('admin.projects')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-layout-dashboard"></i>
                            </div>
                            <div class="action-text">
                                <span>داشبورد پروژه</span>
                                <small>مدیریت پروژه‌ها</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('admin.attendence.requests.create')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-plane-departure"></i>
                            </div>
                            <div class="action-text">
                                <span>مرخصی/ماموریت</span>
                                <small>ثبت درخواست</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('contact.contact_book')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-users"></i>
                            </div>
                            <div class="action-text">
                                <span>مخاطبین</span>
                                <small>دفترچه تماس</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('admin.petty-cash.create')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-wallet"></i>
                            </div>
                            <div class="action-text">
                                <span>تنخواه</span>
                                <small>درخواست مالی</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('admin.payment.create')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-currency-toman"></i>
                            </div>
                            <div class="action-text">
                                <span>درخواست وجه</span>
                                <small>عملیات بانکی</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('purchase.my-requests')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-shopping-cart"></i>
                            </div>
                            <div class="action-text">
                                <span>خرید</span>
                                <small>درخواست کالا</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('admin.announcements.create')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-speakerphone"></i>
                            </div>
                            <div class="action-text">
                                <span>اطلاعیه</span>
                                <small>ارسال پیام</small>
                            </div>
                        </a>
                    </div>

                    <div class="col-6 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('user.posts')); ?>" class="quick-action-btn">
                            <div class="action-icon">
                                <i class="ti ti-news"></i>
                            </div>
                            <div class="action-text">
                                <span>اخبار</span>
                                <small>آخرین اطلاعیه‌ها</small>
                            </div>
                        </a>
                    </div>
                </div>

                
                <div class="row g-4">
                    
                    <div class="col-lg-6">
                        <div class="widget-card card-hover">
                            <div class="widget-card-header">
                                <div>
                                    <h4 class="widget-title">
                                        <i class="ti ti-checklist text-success me-2"></i>
                                        تسک‌های من
                                    </h4>
                                    <p class="widget-subtitle">وظایف اختصاص داده شده به شما</p>
                                </div>
                                <a href="<?php echo e(route('admin.project.task.list', ['project' => $firstProjectId])); ?>?assigned_to=me" class="btn btn-sm btn-success-soft rounded-pill">
                                    همه تسک‌ها
                                </a>
                            </div>
                            <div class="widget-card-body">
                                <div class="task-list">
                                    <?php $__empty_1 = true; $__currentLoopData = $myTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="task-item">
                                            <div class="task-checkbox">
                                                <input type="checkbox" id="task-<?php echo e($task->id); ?>" <?php echo e($task->status == 'completed' ? 'checked' : ''); ?>>
                                                <label for="task-<?php echo e($task->id); ?>">
                                                    <i class="ti ti-check"></i>
                                                </label>
                                            </div>
                                            <div class="task-content">
                                                <h6 class="task-title"><?php echo e(Str::limit($task->title, 50)); ?></h6>
                                                <div class="task-meta">
                                            <span class="task-project">
                                                <i class="ti ti-folder"></i>
                                                <?php echo e($task->project->name ?? '-'); ?>

                                            </span>
                                                    <?php if($task->due_date): ?>
                                                        <span class="task-due <?php echo e(now()->gt($task->due_date) ? 'text-danger' : 'text-muted'); ?>">
                                                <i class="ti ti-calendar"></i>
                                                <?php echo e(verta($task->due_date)->format('Y/m/d')); ?>

                                            </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <div class="task-actions">
                                                <a href="<?php echo e(route('admin.project.task.show', [$task->project_id, $task->id])); ?>" class="btn btn-sm btn-icon">
                                                    <i class="ti ti-arrow-left"></i>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="empty-state">
                                            <i class="ti ti-checklist empty-icon"></i>
                                            <p class="empty-text">هیچ تسکی برای نمایش وجود ندارد</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-lg-6">
                        <div class="widget-card card-hover">
                            <div class="widget-card-header">
                                <div>
                                    <h4 class="widget-title">
                                        <i class="ti ti-layout-grid text-primary me-2"></i>
                                        تسک‌های پروژه
                                    </h4>
                                    <p class="widget-subtitle">وظایف کل پروژه‌ها</p>
                                </div>
                                <a href="<?php echo e(route('admin.project.task.list', ['project' => $firstProjectId])); ?>" class="btn btn-sm btn-primary-soft rounded-pill">
                                    کل تسک‌ها
                                </a>
                            </div>
                            <div class="widget-card-body">
                                <div class="task-list">
                                    <?php $__empty_1 = true; $__currentLoopData = $projectTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="task-item">
                                            <div class="task-checkbox">
                                                <input type="checkbox" id="ptask-<?php echo e($task->id); ?>" <?php echo e($task->status == 'completed' ? 'checked' : ''); ?>>
                                                <label for="ptask-<?php echo e($task->id); ?>">
                                                    <i class="ti ti-check"></i>
                                                </label>
                                            </div>
                                            <div class="task-content">
                                                <h6 class="task-title"><?php echo e(Str::limit($task->title, 50)); ?></h6>
                                                <div class="task-meta">
                                            <span class="task-assignee">
                                                <i class="ti ti-user"></i>
                                                <?php echo e($task->assignedUser->name ?? '-'); ?>

                                            </span>
                                                    <span class="task-project">
                                                <i class="ti ti-briefcase"></i>
                                                <?php echo e($task->project->name ?? '-'); ?>

                                            </span>
                                                </div>
                                            </div>
                                            <div class="task-priority">
                                        <span class="badge bg-<?php echo e($task->priority == 'high' ? 'danger' : ($task->priority == 'medium' ? 'warning' : 'info')); ?>-soft">
                                            <?php echo e($task->priority ?? 'عادی'); ?>

                                        </span>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="empty-state">
                                            <i class="ti ti-layout-grid empty-icon"></i>
                                            <p class="empty-text">تسک جدیدی یافت نشد</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="row g-4 mt-4">
                    <div class="col-lg-12">
                        <div class="widget-card card-hover">
                            <div class="widget-card-header">
                                <div>
                                    <h4 class="widget-title">
                                        <i class="ti ti-timeline text-gradient-info me-2"></i>
                                        فعالیت‌های اخیر
                                    </h4>
                                    <p class="widget-subtitle">آخرین رویدادها در سامانه</p>
                                </div>
                                <button class="btn btn-sm btn-info-soft rounded-pill">
                                    <i class="ti ti-refresh"></i>
                                </button>
                            </div>
                            <div class="widget-card-body">
                                <div class="activity-timeline">
                                    <?php
                                        $activities = [
                                            ['icon' => 'ti ti-file-text', 'color' => 'primary', 'title' => 'پروژه جدید ثبت شد', 'time' => '۲ دقیقه پیش', 'user' => 'شما'],
                                            ['icon' => 'ti ti-mail', 'color' => 'success', 'title' => 'نامه جدید دریافت شد', 'time' => '۱۵ دقیقه پیش', 'user' => 'سیستم'],
                                            ['icon' => 'ti ti-check', 'color' => 'warning', 'title' => 'تسک تکمیل شد', 'time' => '۱ ساعت پیش', 'user' => 'مصطفی عظیمی'],
                                            ['icon' => 'ti ti-shopping-cart', 'color' => 'danger', 'title' => 'درخواست خرید تایید شد', 'time' => '۲ ساعت پیش', 'user' => 'مدیریت'],
                                            ['icon' => 'ti ti-calendar', 'color' => 'info', 'title' => 'جلسه برنامه‌ریزی', 'time' => '۳ ساعت پیش', 'user' => 'سیستم'],
                                        ];
                                    ?>

                                    <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="activity-item">
                                            <div class="activity-icon bg-<?php echo e($activity['color']); ?>-soft">
                                                <i class="<?php echo e($activity['icon']); ?> text-<?php echo e($activity['color']); ?>"></i>
                                            </div>
                                            <div class="activity-content">
                                                <div class="d-flex justify-content-between">
                                                    <h6 class="activity-title"><?php echo e($activity['title']); ?></h6>
                                                    <span class="activity-time"><?php echo e($activity['time']); ?></span>
                                                </div>
                                                <p class="activity-user small text-muted">
                                                    <i class="ti ti-user-circle"></i>
                                                    <?php echo e($activity['user']); ?>

                                                </p>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            
            <div class="col-xl-4">
                
                <div class="profile-card card-hover mb-4">
                    <div class="profile-cover"></div>
                    <div class="profile-content">
                        <div class="profile-avatar">
                            <img src="<?php echo e(asset('storage/' . auth()->user()->image)); ?>"
                                 alt="<?php echo e(auth()->user()->name); ?>"
                                 class="avatar-img-xl">
                            <span class="online-status"></span>
                        </div>
                        <h3 class="profile-name"><?php echo e(auth()->user()->name); ?></h3>
                        <p class="profile-role"><?php echo e(auth()->user()->position ?? 'کاربر سیستم'); ?></p>

                        <div class="profile-stats">
                            <div class="stat-item">
                                <div class="stat-value"><?php echo e($activeProjects); ?></div>
                                <div class="stat-label">پروژه</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-value"><?php echo e($totalLetters); ?></div>
                                <div class="stat-label">نامه</div>
                            </div>
                            <div class="stat-item">
                                <div class="stat-value"><?php echo e($sentCompletedLetters); ?></div>
                                <div class="stat-label">ارجاع</div>
                            </div>
                        </div>

                        <div class="profile-actions mt-4">
                            <a href="#" class="btn btn-sm btn-primary-soft w-100">
                                <i class="ti ti-user-circle me-1"></i>
                                مشاهده پروفایل
                            </a>
                        </div>
                    </div>
                </div>

                
                <div class="widget-card card-hover mb-4">
                    <div class="widget-card-header">
                        <h4 class="widget-title">
                            <i class="ti ti-calendar-event text-gradient-danger me-2"></i>
                            تقویم امروز
                        </h4>
                    </div>
                    <div class="widget-card-body">
                        <div class="calendar-widget">
                            <div class="calendar-header">
                                <div class="current-date">
                                    <div class="date-day"><?php echo e(Verta::today()->day); ?></div>
                                    <div class="date-month"><?php echo e(Verta::today()->format('F')); ?></div>
                                </div>
                                <div class="calendar-info">
                                    <h5 class="mb-1"><?php echo e(Verta::today()->format('l')); ?></h5>
                                    <p class="text-muted small mb-0"><?php echo e(Verta::today()->format('Y/m/d')); ?></p>
                                </div>
                            </div>

                            <?php if($pendingProjects > 0): ?>
                                <div class="calendar-events mt-4">
                                    <div class="event-item">
                                        <div class="event-dot bg-warning"></div>
                                        <div class="event-content">
                                            <h6 class="mb-1"><?php echo e($pendingProjects); ?> پروژه در انتظار</h6>
                                            <p class="text-muted small mb-0">مهلت تحویل نزدیک است</p>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="calendar-actions mt-4">
                                <a href="#" class="btn btn-sm btn-outline-primary w-100">
                                    <i class="ti ti-calendar-time me-1"></i>
                                    مشاهده تقویم کامل
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="widget-card card-hover mb-4">
                    <div class="widget-card-header">
                        <h4 class="widget-title">
                            <i class="ti ti-device-desktop text-gradient-info me-2"></i>
                            وضعیت سیستم
                        </h4>
                    </div>
                    <div class="widget-card-body">
                        <div class="system-status">
                            <div class="status-item mb-3">
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="status-label">فضای ذخیره‌سازی</span>
                                    <span class="status-value">65%</span>
                                </div>
                                <div class="progress" style="height: 8px;">
                                    <div class="progress-bar bg-gradient-primary" style="width: 65%"></div>
                                </div>
                            </div>

                            <div class="status-item mb-3">
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="status-label">پهنای باند</span>
                                    <span class="status-value">42%</span>
                                </div>
                                <div class="progress" style="height: 8px;">
                                    <div class="progress-bar bg-gradient-success" style="width: 42%"></div>
                                </div>
                            </div>

                            <div class="status-item">
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="status-label">کارایی سیستم</span>
                                    <span class="status-value">87%</span>
                                </div>
                                <div class="progress" style="height: 8px;">
                                    <div class="progress-bar bg-gradient-warning" style="width: 87%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="widget-card card-hover">
                    <div class="widget-card-header">
                        <h4 class="widget-title">
                            <i class="ti ti-users text-gradient-success me-2"></i>
                            مخاطبین اخیر
                        </h4>
                        <a href="<?php echo e(route('contact.contact_book')); ?>" class="btn btn-sm btn-success-soft rounded-pill">
                            همه
                        </a>
                    </div>
                    <div class="widget-card-body">
                        <div class="contacts-list">
                            <?php
                                $contacts = [
                                    ['name' => 'مصطفی عظیمی', 'role' => 'مدیر پروژه', 'status' => 'online', 'avatar' => 'MA'],
                                    ['name' => 'سعید محمدی', 'role' => 'توسعه دهنده', 'status' => 'away', 'avatar' => 'SM'],
                                    ['name' => 'سارا نادری', 'role' => 'حسابدار', 'status' => 'offline', 'avatar' => 'SN'],
                                ];
                            ?>

                            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="contact-item">
                                    <div class="contact-avatar">
                                        <span class="avatar-text"><?php echo e($contact['avatar']); ?></span>
                                        <span class="contact-status bg-<?php echo e($contact['status']); ?>"></span>
                                    </div>
                                    <div class="contact-info">
                                        <h6 class="contact-name"><?php echo e($contact['name']); ?></h6>
                                        <p class="contact-role small text-muted"><?php echo e($contact['role']); ?></p>
                                    </div>
                                    <button class="btn btn-sm btn-icon">
                                        <i class="ti ti-phone"></i>
                                    </button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Modern Dashboard CSS */
        :root {
            /* Color Palette - Modern & Professional */
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --primary-light: #eef2ff;
            --secondary: #8b5cf6;
            --success: #10b981;
            --warning: #f59e0b;
            --danger: #ef4444;
            --info: #06b6d4;
            --dark: #1e293b;
            --light: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-600: #475569;

            /* Glass Effect */
            --glass-bg: rgba(255, 255, 255, 0.85);
            --glass-border: rgba(255, 255, 255, 0.2);
            --glass-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);

            /* Gradients */
            --gradient-primary: linear-gradient(135deg, #4361ee 0%, #3a56d4 100%);
            --gradient-warning: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            --gradient-danger: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
            --gradient-success: linear-gradient(135deg, #10b981 0%, #059669 100%);
            --gradient-info: linear-gradient(135deg, #06b6d4 0%, #0891b2 100%);

            /* Soft Colors */
            --primary-soft: #eef2ff;
            --success-soft: #d1fae5;
            --warning-soft: #fef3c7;
            --danger-soft: #fee2e2;
            --info-soft: #cffafe;

            /* Transitions */
            --transition-fast: 0.2s ease;
            --transition-base: 0.3s ease;
            --transition-slow: 0.5s ease;

            /* Border Radius */
            --radius-sm: 8px;
            --radius-md: 12px;
            --radius-lg: 16px;
            --radius-xl: 24px;
            --radius-2xl: 32px;
        }

        /* Base Styles */
        .dashboard-modern {
            background: linear-gradient(135deg, #f0f4f8 0%, #d9e2ec 100%);
            min-height: 100vh;
            font-family: 'Vazirmatn', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Glass Effects */
        .glass-effect {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            border: 1px solid var(--glass-border);
            box-shadow: var(--glass-shadow);
        }

        /* Alert Glass */
        .alert-glass {
            background: rgba(255, 243, 205, 0.9);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 234, 186, 0.5);
            border-radius: var(--radius-lg);
            padding: 1rem 1.25rem;
        }

        /* Search Bar Glass */
        .search-bar-glass {
            background: var(--glass-bg);
            backdrop-filter: blur(10px);
            border: 1px solid var(--glass-border);
            border-radius: var(--radius-xl);
            padding: 0.5rem 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .form-control-glass {
            border: none;
            background: transparent;
            outline: none;
            width: 100%;
            color: var(--dark);
        }

        .form-control-glass::placeholder {
            color: var(--gray-600);
        }

        /* Card Styles */
        .card-hover {
            background: white;
            border-radius: var(--radius-lg);
            border: 1px solid var(--gray-200);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
            transition: var(--transition-base);
        }

        .card-hover:hover {
            transform: translateY(-4px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border-color: var(--primary-light);
        }

        /* Metric Cards */
        .metric-card {
            background: white;
            border-radius: var(--radius-lg);
            border: 1px solid var(--gray-200);
            overflow: hidden;
            transition: var(--transition-base);
        }

        .metric-card:hover {
            transform: translateY(-4px);
            border-color: var(--primary);
            box-shadow: 0 20px 25px -5px rgba(67, 97, 238, 0.1), 0 10px 10px -5px rgba(67, 97, 238, 0.04);
        }

        .metric-card-body {
            padding: 1.5rem;
        }

        .metric-icon-wrapper {
            width: 48px;
            height: 48px;
            border-radius: var(--radius-md);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
        }

        .metric-value {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--dark);
            line-height: 1;
            margin: 0.5rem 0;
        }

        .metric-label {
            color: var(--gray-600);
            font-size: 0.875rem;
            margin-bottom: 0;
        }

        .metric-card-footer {
            background: var(--gray-100);
            padding: 1rem 1.5rem;
            border-top: 1px solid var(--gray-200);
        }

        .metric-link {
            color: var(--primary);
            text-decoration: none;
            font-weight: 500;
            display: flex;
            align-items: center;
            justify-content: space-between;
            transition: var(--transition-fast);
        }

        .metric-link:hover {
            color: var(--primary-dark);
        }

        /* Quick Action Buttons */
        .quick-action-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 1.25rem 0.75rem;
            background: white;
            border: 1px solid var(--gray-200);
            border-radius: var(--radius-lg);
            text-decoration: none;
            color: var(--dark);
            transition: var(--transition-base);
            text-align: center;
        }

        .quick-action-btn:hover {
            background: var(--primary-light);
            border-color: var(--primary);
            transform: translateY(-2px);
            color: var(--primary-dark);
        }

        .quick-action-btn .action-icon {
            width: 48px;
            height: 48px;
            border-radius: var(--radius-md);
            background: var(--primary-soft);
            color: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            margin-bottom: 0.75rem;
            transition: var(--transition-base);
        }

        .quick-action-btn:hover .action-icon {
            background: var(--primary);
            color: white;
        }

        .action-text span {
            display: block;
            font-weight: 600;
            font-size: 0.875rem;
            margin-bottom: 0.25rem;
        }

        .action-text small {
            color: var(--gray-600);
            font-size: 0.75rem;
        }

        /* Widget Cards */
        .widget-card {
            background: white;
            border-radius: var(--radius-lg);
            border: 1px solid var(--gray-200);
            margin-bottom: 1rem;
        }

        .widget-card-header {
            padding: 1.25rem 1.5rem;
            border-bottom: 1px solid var(--gray-200);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .widget-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark);
            margin: 0;
            display: flex;
            align-items: center;
        }

        .widget-subtitle {
            color: var(--gray-600);
            font-size: 0.875rem;
            margin: 0.25rem 0 0 0;
        }

        .widget-card-body {
            padding: 1.5rem;
        }

        /* Task List */
        .task-list {
            max-height: 300px;
            overflow-y: auto;
        }

        .task-item {
            display: flex;
            align-items: center;
            padding: 0.75rem;
            border-radius: var(--radius-md);
            transition: var(--transition-fast);
            margin-bottom: 0.5rem;
        }

        .task-item:hover {
            background: var(--gray-100);
        }

        .task-checkbox {
            position: relative;
            margin-left: 0.75rem;
        }

        .task-checkbox input[type="checkbox"] {
            display: none;
        }

        .task-checkbox label {
            width: 20px;
            height: 20px;
            border: 2px solid var(--gray-300);
            border-radius: 6px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: var(--transition-fast);
        }

        .task-checkbox input[type="checkbox"]:checked + label {
            background: var(--success);
            border-color: var(--success);
            color: white;
        }

        .task-checkbox label i {
            font-size: 0.75rem;
            opacity: 0;
            transition: var(--transition-fast);
        }

        .task-checkbox input[type="checkbox"]:checked + label i {
            opacity: 1;
        }

        .task-content {
            flex: 1;
        }

        .task-title {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--dark);
            margin: 0 0 0.25rem 0;
        }

        .task-meta {
            display: flex;
            gap: 1rem;
            font-size: 0.75rem;
            color: var(--gray-600);
        }

        /* Profile Card */
        .profile-card {
            background: white;
            border-radius: var(--radius-lg);
            overflow: hidden;
            position: relative;
        }

        .profile-cover {
            height: 120px;
            background: var(--gradient-primary);
        }

        .profile-content {
            padding: 0 1.5rem 1.5rem;
            text-align: center;
            position: relative;
            margin-top: -60px;
        }

        .profile-avatar {
            position: relative;
            display: inline-block;
            margin-bottom: 1rem;
        }

        .avatar-img-xl {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            border: 4px solid white;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        }

        .online-status {
            position: absolute;
            bottom: 10px;
            right: 10px;
            width: 16px;
            height: 16px;
            background: var(--success);
            border: 2px solid white;
            border-radius: 50%;
        }

        .profile-name {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--dark);
            margin: 0 0 0.25rem 0;
        }

        .profile-role {
            color: var(--gray-600);
            font-size: 0.875rem;
            margin: 0 0 1rem 0;
        }

        .profile-stats {
            display: flex;
            justify-content: space-around;
            margin: 1.5rem 0;
        }

        .stat-item {
            text-align: center;
        }

        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            color: var(--primary);
            display: block;
        }

        .stat-label {
            font-size: 0.75rem;
            color: var(--gray-600);
            display: block;
        }

        /* Calendar Widget */
        .calendar-widget {
            text-align: center;
        }

        .calendar-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .current-date {
            background: var(--gradient-danger);
            color: white;
            padding: 1rem;
            border-radius: var(--radius-lg);
            min-width: 80px;
        }

        .date-day {
            font-size: 2rem;
            font-weight: 700;
            line-height: 1;
        }

        .date-month {
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        .calendar-info {
            text-align: right;
            flex: 1;
        }

        /* Activity Timeline */
        .activity-timeline {
            position: relative;
            padding-right: 2rem;
        }

        .activity-timeline::before {
            content: '';
            position: absolute;
            right: 0.75rem;
            top: 0;
            bottom: 0;
            width: 2px;
            background: var(--gray-200);
        }

        .activity-item {
            position: relative;
            margin-bottom: 1.5rem;
            padding-right: 2rem;
        }

        .activity-icon {
            position: absolute;
            right: -2rem;
            top: 0;
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
            z-index: 1;
        }

        .activity-content {
            background: var(--gray-100);
            padding: 0.75rem 1rem;
            border-radius: var(--radius-md);
        }

        .activity-title {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--dark);
            margin: 0;
        }

        .activity-time {
            font-size: 0.75rem;
            color: var(--gray-600);
        }

        /* Contacts List */
        .contacts-list {
            max-height: 250px;
            overflow-y: auto;
        }

        .contact-item {
            display: flex;
            align-items: center;
            padding: 0.75rem;
            border-radius: var(--radius-md);
            transition: var(--transition-fast);
            margin-bottom: 0.5rem;
        }

        .contact-item:hover {
            background: var(--gray-100);
        }

        .contact-avatar {
            position: relative;
            margin-left: 0.75rem;
        }

        .avatar-text {
            width: 40px;
            height: 40px;
            background: var(--primary-soft);
            color: var(--primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
        }

        .contact-status {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 10px;
            height: 10px;
            border: 2px solid white;
            border-radius: 50%;
        }

        .contact-status.bg-online {
            background: var(--success);
        }

        .contact-status.bg-away {
            background: var(--warning);
        }

        .contact-status.bg-offline {
            background: var(--gray-400);
        }

        .contact-info {
            flex: 1;
        }

        .contact-name {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--dark);
            margin: 0 0 0.125rem 0;
        }

        .contact-role {
            margin: 0;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 2rem;
            color: var(--gray-600);
        }

        .empty-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            opacity: 0.5;
        }

        .empty-text {
            font-size: 0.875rem;
            margin: 0;
        }

        /* Animations */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in {
            animation: fadeIn 0.5s ease-out;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }

        .pulse {
            animation: pulse 2s infinite;
        }

        /* Scrollbar Styling */
        ::-webkit-scrollbar {
            width: 6px;
        }

        ::-webkit-scrollbar-track {
            background: var(--gray-100);
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb {
            background: var(--gray-300);
            border-radius: 3px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: var(--gray-400);
        }

        /* Text Gradients */
        .text-gradient-primary {
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .text-gradient-warning {
            background: var(--gradient-warning);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .text-gradient-danger {
            background: var(--gradient-danger);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .text-gradient-success {
            background: var(--gradient-success);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .text-gradient-info {
            background: var(--gradient-info);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        /* Button Styles */
        .btn-primary-soft {
            background: var(--primary-soft);
            color: var(--primary);
            border: 1px solid var(--primary-soft);
        }

        .btn-success-soft {
            background: var(--success-soft);
            color: var(--success);
            border: 1px solid var(--success-soft);
        }

        .btn-warning-soft {
            background: var(--warning-soft);
            color: var(--warning);
            border: 1px solid var(--warning-soft);
        }

        .btn-danger-soft {
            background: var(--danger-soft);
            color: var(--danger);
            border: 1px solid var(--danger-soft);
        }

        .btn-info-soft {
            background: var(--info-soft);
            color: var(--info);
            border: 1px solid var(--info-soft);
        }

        .btn-icon {
            width: 32px;
            height: 32px;
            padding: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
        }

        /* Badge Styles */
        .badge {
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
            font-weight: 500;
            border-radius: 6px;
        }

        /* Progress Bars */
        .progress {
            border-radius: 4px;
            background: var(--gray-200);
        }

        .progress-bar {
            border-radius: 4px;
        }

        /* Gradient Progress Bars */
        .bg-gradient-primary {
            background: var(--gradient-primary);
        }

        .bg-gradient-success {
            background: var(--gradient-success);
        }

        .bg-gradient-warning {
            background: var(--gradient-warning);
        }

        .bg-gradient-danger {
            background: var(--gradient-danger);
        }

        .bg-gradient-info {
            background: var(--gradient-info);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .dashboard-header {
                flex-direction: column;
                gap: 1rem;
            }

            .welcome-section {
                text-align: center;
            }

            .metric-value {
                font-size: 2rem;
            }

            .quick-action-btn {
                padding: 1rem 0.5rem;
            }

            .profile-stats {
                gap: 1rem;
            }
        }
    </style>

    <script>
        // Initialize animations and interactions
        document.addEventListener('DOMContentLoaded', function() {
            // Animated counters for metrics
            const metricCards = document.querySelectorAll('.metric-card');

            metricCards.forEach(card => {
                const valueElement = card.querySelector('.metric-value');
                if (valueElement && !isNaN(valueElement.textContent)) {
                    const finalValue = parseInt(valueElement.textContent);
                    const duration = 2000;
                    const frameDuration = 1000 / 60;
                    const totalFrames = Math.round(duration / frameDuration);
                    let frame = 0;

                    const counter = setInterval(() => {
                        frame++;
                        const progress = frame / totalFrames;
                        const currentValue = Math.round(finalValue * progress);

                        valueElement.textContent = currentValue;

                        if (frame === totalFrames) {
                            clearInterval(counter);
                            valueElement.textContent = finalValue;
                        }
                    }, frameDuration);
                }
            });

            // Task completion toggle
            const taskCheckboxes = document.querySelectorAll('.task-checkbox input[type="checkbox"]');
            taskCheckboxes.forEach(checkbox => {
                checkbox.addEventListener('change', function() {
                    const label = this.nextElementSibling;
                    if (this.checked) {
                        label.style.background = '#10b981';
                        label.style.borderColor = '#10b981';
                    } else {
                        label.style.background = '';
                        label.style.borderColor = '';
                    }
                });
            });

            // Search functionality
            const searchInput = document.querySelector('.form-control-glass');
            const searchButton = document.querySelector('.search-bar-glass .btn');

            searchButton.addEventListener('click', function() {
                performSearch();
            });

            searchInput.addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    performSearch();
                }
            });

            function performSearch() {
                const query = searchInput.value.trim();
                if (query) {
                    // Implement search logic here
                    console.log('Searching for:', query);
                    // You can redirect or filter content based on search query
                }
            }

            // Profile status update
            const onlineStatus = document.querySelector('.online-status');
            if (onlineStatus) {
                // Simulate status update
                setInterval(() => {
                    onlineStatus.style.animation = 'pulse 2s infinite';
                    setTimeout(() => {
                        onlineStatus.style.animation = '';
                    }, 2000);
                }, 10000);
            }

            // Calendar event hover effects
            const calendarEvents = document.querySelectorAll('.event-item');
            calendarEvents.forEach(event => {
                event.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateX(-5px)';
                    this.style.transition = 'transform 0.2s ease';
                });

                event.addEventListener('mouseleave', function() {
                    this.style.transform = 'translateX(0)';
                });
            });

            // Contact item interactions
            const contactItems = document.querySelectorAll('.contact-item');
            contactItems.forEach(item => {
                const callButton = item.querySelector('.btn-icon');
                if (callButton) {
                    callButton.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        const contactName = item.querySelector('.contact-name').textContent;
                        console.log('Calling:', contactName);
                        // Implement call functionality here
                    });
                }
            });

            // System status update simulation
            const systemStatusItems = document.querySelectorAll('.status-item');
            setInterval(() => {
                systemStatusItems.forEach(item => {
                    const progressBar = item.querySelector('.progress-bar');
                    const valueSpan = item.querySelector('.status-value');

                    if (progressBar && valueSpan) {
                        const currentWidth = parseInt(progressBar.style.width);
                        const currentValue = parseInt(valueSpan.textContent);
                        const randomChange = Math.random() * 5 - 2.5; // -2.5 to +2.5
                        const newValue = Math.max(0, Math.min(100, currentValue + randomChange));

                        valueSpan.textContent = Math.round(newValue) + '%';
                        progressBar.style.width = newValue + '%';
                    }
                });
            }, 15000); // Update every 15 seconds
        });
    </script>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\user\dashboard.blade.php ENDPATH**/ ?>