<div class="container py-4 modern-task-create-form">
    
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-3 mb-3 shadow-md border-0 bg-success-soft text-success">
            <i class="ti ti-check me-2 fs-5"></i><?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-xl border-0 rounded-4 fadein-box">
        <div class="card-body px-5 py-5">
            
            <h4 class="fw-bold text-dark-primary mb-4 border-bottom pb-3 d-flex align-items-center">
                <i class="ti ti-edit me-2 text-warning-custom fs-4"></i> ویرایش تسک: <span class="text-info-accent ms-2"><?php echo e(Str::limit($title, 40)); ?></span>
            </h4>

            <form wire:submit.prevent="updateTask" autocomplete="off" class="needs-validation">

                <div class="row g-5">

                    
                    <div class="col-lg-6 border-end-lg pe-lg-5 card-section-hover">
                        <h6 class="fw-bold mb-4 text-action-primary">
                            <i class="ti ti-info-circle me-2"></i> جزئیات اصلی
                        </h6>

                        
                        <div class="mb-4">
                            <label class="form-label text-dark-primary">عنوان تسک <span class="text-danger">*</span></label>
                            <input wire:model.defer="title" type="text"
                                   class="form-control rounded-pill <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                   placeholder="خلاصه کار مورد نیاز" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-4">
                            <label class="form-label text-dark-primary">مسئول انجام</label>
                            <select wire:model.defer="assigned_to" class="form-select rounded-pill <?php $__errorArgs = ['assigned_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">انتخاب مسئول...</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['assigned_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-4">
                            <label class="form-label text-dark-primary">بخش پروژه</label>
                            <select wire:model.defer="section_id" class="form-select rounded-pill <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">بدون بخش</option>
                                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($section->id); ?>"><?php echo e($section->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['section_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        
                        <div class="mb-4">
                            <label class="form-label text-dark-primary">توضیحات</label>
                            <textarea wire:model.defer="description" class="form-control rounded-3 <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4" placeholder="جزئیات کامل تسک، نیازمندی‌ها..."></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                    </div>

                    
                    <div class="col-lg-6 ps-lg-5 card-section-hover">
                        <h6 class="fw-bold mb-4 text-success">
                            <i class="ti ti-clock me-2"></i> زمان‌بندی و وضعیت
                        </h6>

                        
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <label class="form-label text-dark-primary">وضعیت</label>
                                <select wire:model="status" class="form-select rounded-pill">
                                    <option value="new">جدید</option>
                                    <option value="in_progress">درحال انجام</option>
                                    <option value="done">انجام شده</option>
                                    <option value="on_hold">متوقف</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label class="form-label text-dark-primary">اولویت</label>
                                <select wire:model="priority" class="form-select rounded-pill">
                                    <option value="low">پایین</option>
                                    <option value="normal">متوسط</option>
                                    <option value="high">زیاد</option>
                                    <option value="critical">بحرانی</option>
                                </select>
                            </div>
                        </div>

                        
                        <div class="mb-4">
                            <label class="form-label text-dark-primary">نوع</label>
                            <select wire:model="type" class="form-select rounded-pill">
                                <option value="task">Task (عادی)</option>
                                <option value="issue">Issue (ایراد/درخواست)</option>
                                <option value="bug">Bug (باگ)</option>
                                <option value="feature">Feature (امکان جدید)</option>
                            </select>
                        </div>


                        
                        <div class="row g-3">
                            <div class="col-md-6" wire:ignore>
                                <label class="form-label text-dark-primary">تاریخ شروع</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-calendar-event"></i></span>
                                    <input type="text"
                                           id="start_date_picker"
                                           class="form-control <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           placeholder="مثال: 1402/01/01" autocomplete="off">
                                </div>
                                <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6" wire:ignore>
                                <label class="form-label text-dark-primary">مهلت نهایی</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ti ti-calendar-x"></i></span>
                                    <input type="text"
                                           id="due_date_picker"
                                           class="form-control <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                           placeholder="مثال: 1402/01/15" autocomplete="off">
                                </div>
                                <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><div class="invalid-feedback d-block"><?php echo e($message); ?></div><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        
                        <h6 class="fw-bold text-info mt-5 mb-3">
                            <i class="ti ti-link me-2"></i> ساختار و وابستگی‌ها
                        </h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label for="dependency_id" class="form-label">وابسته به تسک</label>
                                <select id="dependency_id" wire:model.defer="dependency_id" class="form-select rounded-pill">
                                    <option value="">بدون وابستگی</option>
                                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($task->id); ?>">#<?php echo e($task->id); ?> - <?php echo e(Str::limit($task->title, 30)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="parent_id" class="form-label">تسک والد</label>
                                <select id="parent_id" wire:model.defer="parent_id" class="form-select rounded-pill">
                                    <option value="">ندارد (تسک اصلی)</option>
                                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($task->id); ?>">#<?php echo e($task->id); ?> - <?php echo e(Str::limit($task->title, 30)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        
                        <div class="mt-5 pt-3 border-top">
                            <label for="progress_percent" class="form-label text-dark-primary">
                                درصد پیشرفت:
                                <span class="fw-bold text-action-primary ms-2"><?php echo e($progress_percent); ?>%</span>
                                <i class="ti ti-circle-half me-1 text-secondary-light"></i>
                            </label>
                            <input type="range" id="progress_percent" wire:model.live="progress_percent" min="0" max="100" class="form-range custom-range-slider" style="--progress-value: <?php echo e($progress_percent); ?>%">
                        </div>
                    </div>
                </div>

                
                <div class="d-flex justify-content-end mt-5 pt-4 border-top">
                    <a href="<?php echo e(route('admin.project.task.list', ['project' => $projectId])); ?>" class="btn btn-outline-secondary fw-bold px-4 py-2 rounded-pill me-2">
                        <i class="ti ti-x me-1"></i> انصراف و بازگشت
                    </a>
                    <button type="submit" class="btn btn-action-primary fw-bold px-5 py-2 rounded-pill shadow-action-btn">
                        <span wire:loading.remove><i class="ti ti-device-floppy me-1"></i> ذخیره تغییرات</span>
                        <span wire:loading>
                            <span class="spinner-border spinner-border-sm me-1" role="status"></span>
                            در حال ذخیره...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        // NOTE: فرض بر این است که کتابخانه‌های jQuery و persianDatepicker در پروژه شما لود شده‌اند.

        document.addEventListener('livewire:navigated', function () {
            // Reinitialize datepickers after Livewire navigation
            initDatepickers();
        });

        document.addEventListener('livewire:load', function () {

            function initDatepickers() {
                // Attach to start date picker
                $('#start_date_picker').persianDatepicker({
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    initialValueType: 'persian',
                    observer: true,
                    persianDigit: true,
                    onSelect: function(unix) {
                        // Send the selected date (e.g., "1402/10/25") to Livewire component
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('start_date', this.value);
                    }
                });

                // Attach to due date picker
                $('#due_date_picker').persianDatepicker({
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    initialValueType: 'persian',
                    observer: true,
                    persianDigit: true,
                    onSelect: function() {
                        // Send the selected date to Livewire component
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('due_date', this.value);
                    }
                });

                // 🛑 Set initial values from Livewire (must be in the Persian format expected by datepicker)
                // توجه: اگر $start_date در PHP میلادی است، باید آن را اینجا با JS به شمسی تبدیل کنید یا در متد mount این کار را انجام دهید.

                const initialStartDate = window.Livewire.find('<?php echo e($_instance->getId()); ?>').get('start_date');
                if (initialStartDate) {
                    $('#start_date_picker').val(initialStartDate);
                }
                const initialDueDate = window.Livewire.find('<?php echo e($_instance->getId()); ?>').get('due_date');
                if (initialDueDate) {
                    $('#due_date_picker').val(initialDueDate);
                }
            }

            initDatepickers();
        });
    </script>

    <style>
        /* --- General Colors and Variables --- */
        :root {
            --primary-color: #4361ee;
            --primary-dark: #3A0CA3;
            --action-color: var(--primary-color);
            --success-color: #10B981;
            --warning-color: #F59E0B;
            --info-color: #03A9F4;
            --dark-color: #1F2937;
            --muted-color: #6B7280;
            --border-color: #E5E7EB;
            --card-bg: #FFFFFF;
            --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            --shadow-action-btn: 0 4px 12px rgba(67, 97, 238, 0.3);
            --primary-light-bg: #F0F3FF;
            --danger-color: #EF4444;
            --success-soft: #ECFDF5;
        }

        /* --- Base Aesthetics --- */
        body { background-color: #F8FAFC; }
        .text-dark-primary { color: var(--dark-color) !important; }
        .text-action-primary { color: var(--action-color) !important; }
        .text-warning-custom { color: var(--warning-color) !important; }
        .text-info-accent { color: var(--info-color) !important; }
        .shadow-action-btn { box-shadow: var(--shadow-action-btn); }
        .card { border-radius: 1.2rem !important; }

        /* --- Forms & Inputs --- */
        .form-control, .form-select {
            border-color: var(--border-color);
            border-radius: 0.75rem !important;
            padding: 0.65rem 1rem;
        }
        .form-control.rounded-pill, .form-select.rounded-pill {
            border-radius: 50rem !important;
            padding: 0.75rem 1.25rem;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--action-color);
            box-shadow: 0 0 0 2px rgba(67, 97, 238, 0.15);
        }

        /* Layout and Grouping Containers */
        .border-end-lg { border-right: 1px solid var(--border-color); }
        .card-section-hover { transition: all 0.3s ease-out; }
        .card-section-hover:hover {
            background-color: var(--primary-light-bg);
        }
        @media (max-width: 991px) {
            .border-end-lg {
                border-right: none !important;
                border-bottom: 1px solid var(--border-color) !important;
                padding-bottom: 2.5rem !important;
            }
        }

        /* --- Input Group Styling (Reversed RTL Style) --- */
        .input-group .form-control {
            border-top-right-radius: 0.75rem !important; /* In RTL, the control is on the right */
            border-bottom-right-radius: 0.75rem !important;
            border-left: none;
            border-right: 1px solid var(--border-color);
            padding-right: 1rem;
        }
        .input-group-text {
            border-top-left-radius: 0.75rem !important; /* Text is on the left */
            border-bottom-left-radius: 0.75rem !important;
            border-left: 1px solid var(--border-color);
            border-right: none;
            background-color: #F8FAFC;
        }

        /* --- Range Slider (Smart Fill) --- */
        .custom-range-slider {
            height: 1.5rem;
            background-color: #F1F5F9;
            border-radius: 8px;
            cursor: pointer;
            -webkit-appearance: none;
            /* Dynamic background based on Livewire model */
            background: linear-gradient(to left, var(--action-color) var(--progress-value), #F1F5F9 var(--progress-value));
            background-repeat: no-repeat;
            direction: ltr; /* Force LTR for slider track filling */
        }
        .custom-range-slider::-webkit-slider-thumb {
            -webkit-appearance: none;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: white;
            border: 3px solid var(--action-color);
            box-shadow: 0 0 5px rgba(0,0,0,0.1);
            cursor: pointer;
        }

        /* --- Buttons --- */
        .btn-action-primary {
            background-color: var(--action-color) !important;
            border-color: var(--action-color) !important;
            color: white !important;
        }
        .btn-action-primary:hover {
            background-color: var(--primary-dark) !important;
            border-color: var(--primary-dark) !important;
            transform: translateY(-1px);
        }
        .btn-outline-secondary {
            color: var(--muted-color);
            border-color: var(--muted-color);
        }
        .btn-outline-secondary:hover {
            color: var(--dark-color);
            background-color: var(--border-color);
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\task\task-edit.blade.php ENDPATH**/ ?>