<div class="container-fluid" x-data="salesInvoiceState(<?php if ((object) ('items') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('items'->value()); ?>')<?php echo e('items'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('items'); ?>')<?php endif; ?>)">
    <style>
        .sales-header { background: linear-gradient(135deg, #0f4c81 0%, #3b82f6 100%); color: white; border-radius: 0.75rem 0.75rem 0 0; padding: 1.5rem; }
        .sales-info-card { border-left: 5px solid #0f4c81; padding: 1.5rem; background: #f0f7ff; border-radius: 0.75rem; }
        .table-primary-header th { background-color: #0f4c81 !important; color: white; }
        .totals-summary { border: 2px solid #3c9a5f; background: #f0fdf4; border-radius: 0.75rem; padding: 1rem; }
        .total-amount-display { font-size: 1.8rem; font-weight: 800; color: #3c9a5f; }
        .text-accent { color: #0f4c81; }
        .card-shadow-lg { box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1); }
        .form-control, .form-select { border-radius: 0.5rem; }
        .form-label { font-size: 0.85rem; font-weight: 600; }
        .btn-action { padding: 0.6rem 1.5rem; }
    </style>

    <div class="card card-shadow-lg border-0 rounded-3">
        <div class="sales-header">
            <h4 class="fw-bold mb-1"><i class="ti ti-receipt me-2"></i> ثبت فاکتور فروش پروژه</h4>
            <p class="mb-0 opacity-80">مدیریت درآمدهای پروژه و صدور فاکتور رسمی</p>
        </div>

        <div class="card-body p-4">
            <?php if(session()->has('message') || session()->has('error')): ?>
                <div class="alert alert-<?php echo e(session()->has('message') ? 'success' : 'danger'); ?> mb-4">
                    <?php echo e(session('message') ?? session('error')); ?>

                </div>
            <?php endif; ?>

            <form wire:submit.prevent="saveInvoice">

                <!-- اطلاعات اصلی فاکتور -->
                <div class="sales-info-card mb-5">
                    <h6 class="fw-bold mb-3 text-accent"><i class="ti ti-info-circle me-1"></i> اطلاعات پایه فاکتور</h6>
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">پروژه <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="project_id" required>
                                <option value="">انتخاب پروژه</option>
                                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">شماره فاکتور <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['invoice_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="invoice_number" required placeholder="شماره فاکتور">
                            <?php $__errorArgs = ['invoice_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-4">
                            <label class="form-label">نام خریدار/مشتری <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['client_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model="client_name" required placeholder="نام مشتری">
                            <?php $__errorArgs = ['client_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">تاریخ صدور (شمسی) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control shamsi-date-picker" id="issue_date_input" placeholder="1404/07/18">
                            <?php $__errorArgs = ['issue_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">تاریخ سررسید (شمسی) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control shamsi-date-picker" id="due_date_input" placeholder="1404/08/18">
                            <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">توضیحات کلی</label>
                            <textarea class="form-control" wire:model="description" rows="1" placeholder="شرح مختصر فاکتور"></textarea>
                        </div>
                    </div>
                </div>

                <!-- افزودن آیتم‌ها -->
                <h5 class="fw-bold mb-3 mt-4 text-accent"><i class="ti ti-list-details me-2"></i> جزئیات کالا/خدمات فروخته شده</h5>

                <div class="row g-3 p-3 border rounded-3 mb-4">
                    <div class="col-md-5">
                        <label class="form-label">شرح کالا/خدمت <span class="text-danger">*</span></label>
                        <textarea class="form-control" x-model="newItem.description" rows="1" placeholder="شرح کامل آیتم"></textarea>
                        <?php $__errorArgs = ['new_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">تعداد <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" x-model.number="newItem.quantity" min="1">
                        <?php $__errorArgs = ['new_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">قیمت واحد (به <?php echo e($currency); ?>) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" x-model.number="newItem.unit_price" min="0"/>
                        <small class="text-muted mt-1 d-block" x-show="newItem.unit_price > 0">
                            جمع جزء: <span class="fw-bold" x-text="formatNumber(newItem.quantity * newItem.unit_price)"></span> <?php echo e($currency); ?>

                        </small>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="button" class="btn btn-success w-100 py-2 rounded-pill btn-action"
                                @click="addItem()" :disabled="!isItemValid()">
                            <i class="ti ti-plus"></i> افزودن
                        </button>
                    </div>
                </div>

                <!-- جدول آیتم‌ها -->
                <div class="table-responsive mb-4">
                    <table class="table table-bordered table-sm align-middle">
                        <thead class="table-primary-header">
                        <tr>
                            <th>شرح</th>
                            <th style="width: 10%;">تعداد</th>
                            <th style="width: 20%;">قیمت واحد (<?php echo e($currency); ?>)</th>
                            <th style="width: 20%;">جمع جزء (<?php echo e($currency); ?>)</th>
                            <th style="width: 10%;">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <template x-for="(item, index) in items" :key="index">
                            <tr>
                                <td x-text="item.description"></td>
                                <td x-text="item.quantity"></td>
                                <td x-text="formatNumber(item.unit_price)"></td>
                                <td class="fw-bold" x-text="formatNumber(item.quantity * item.unit_price)"></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger rounded-circle"
                                            @click="removeItem(index)" title="حذف آیتم">
                                        <i class="ti ti-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        </template>
                        <template x-if="items.length === 0">
                            <tr>
                                <td colspan="5" class="text-center text-muted py-3">آیتمی اضافه نشده است.</td>
                            </tr>
                        </template>
                        </tbody>
                    </table>
                </div>

                <!-- محاسبات مالی -->
                <h5 class="fw-bold mb-3 mt-4 text-accent"><i class="ti ti-currency-dollar me-2"></i> محاسبات مالی و ارز</h5>
                <div class="row justify-content-end g-4">
                    <div class="col-md-6">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">نوع ارز</label>
                                <select class="form-select" wire:model.live="currency">
                                    <?php $__currentLoopData = $availableCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($code); ?>"><?php echo e($name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">نرخ تبدیل (ریال به ۱ <?php echo e($currency); ?>)</label>
                                <input type="number" class="form-control" wire:model.live="exchange_rate"
                                       min="0.01" step="0.01" <?php if($currency === 'IRR'): ?> disabled <?php endif; ?>>
                                <?php $__errorArgs = ['exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="row g-3 mt-3">
                            <div class="col-md-6">
                                <label class="form-label">نرخ مالیات (٪)</label>
                                <input type="number" class="form-control" wire:model.live="tax_rate" min="0" max="100">
                                <?php $__errorArgs = ['tax_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="totals-summary">
                            <h6 class="fw-bold text-accent border-bottom pb-2 mb-3">خلاصه مبلغ (<?php echo e($currency); ?>)</h6>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">مبلغ خالص:</span>
                                <span class="fw-bold"><?php echo e(number_format($totals['net'])); ?></span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted">مالیات (<?php echo e($tax_rate); ?>٪):</span>
                                <span class="fw-bold text-danger"><?php echo e(number_format($totals['tax'])); ?></span>
                            </div>
                            <div class="d-flex justify-content-between border-top pt-2">
                                <h5 class="fw-bold text-dark">قابل پرداخت:</h5>
                                <h5 class="total-amount-display"><?php echo e(number_format($totals['total_foreign'])); ?> <?php echo e($currency); ?></h5>
                            </div>
                            <?php if($currency !== 'IRR'): ?>
                                <div class="d-flex justify-content-between border-top pt-2 mt-2 bg-light p-2 rounded">
                                    <span class="fw-bold text-dark small">معادل ریالی:</span>
                                    <span class="fw-bold total-amount-display text-accent small"><?php echo e(number_format($totals['total_irr'])); ?> IRR</span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- دکمه ثبت -->
                <div class="text-center mt-5 border-top pt-4">
                    <button type="submit" class="btn btn-primary btn-lg rounded-pill px-5 btn-action"
                            wire:loading.attr="disabled" wire:target="saveInvoice">
                        <span wire:loading.remove wire:target="saveInvoice">
                            <i class="ti ti-send me-2"></i> ثبت فاکتور
                        </span>
                        <span wire:loading wire:target="saveInvoice">
                            <span class="spinner-border spinner-border-sm" role="status"></span> در حال ثبت...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://unpkg.com/persian-date@latest/dist/persian-date.min.js"></script>
        <script src="https://unpkg.com/persian-datepicker@latest/dist/js/persian-datepicker.min.js"></script>
        <link rel="stylesheet" href="https://unpkg.com/persian-datepicker@latest/dist/css/persian-datepicker.min.css">

        <script>
            function salesInvoiceState(initialItems) {
                return {
                    items: initialItems,
                    newItem: { description: '', quantity: 1, unit_price: 0 },

                    formatNumber(number) {
                        if (!number && number !== 0) return '۰';
                        return new Intl.NumberFormat('fa-IR').format(number);
                    },

                    isItemValid() {
                        return this.newItem.description.trim() !== '' &&
                            this.newItem.quantity > 0 &&
                            this.newItem.unit_price >= 0;
                    },

                    addItem() {
                        if (!this.isItemValid()) return;

                        this.items.push({
                            description: this.newItem.description,
                            quantity: Number(this.newItem.quantity),
                            unit_price: Number(this.newItem.unit_price)
                        });

                        this.newItem = { description: '', quantity: 1, unit_price: 0 };
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('items', this.items);
                    },

                    removeItem(index) {
                        this.items.splice(index, 1);
                        window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('items', this.items);
                    }
                };
            }

            const initDatepickers = () => {
                const options = {
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    initialValueType: 'persian',
                    onSelect: function (unixDate) {
                        const formatted = new persianDate(unixDate).format('YYYY/MM/DD');
                        if (this.target.id === 'issue_date_input') {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('issue_date', formatted);
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('updatedIssueDate', formatted);
                        } else if (this.target.id === 'due_date_input') {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('due_date', formatted);
                        }
                    }
                };

                document.querySelectorAll('.shamsi-date-picker').forEach(el => {
                    if (!el.picker) {
                        el.picker = new persianDatepicker(el, options);
                    }
                });
            };

            document.addEventListener('DOMContentLoaded', initDatepickers);
            document.addEventListener('livewire:init', () => {
                Livewire.hook('message.processed', () => {
                    initDatepickers();
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\payment\create-sales-invoice.blade.php ENDPATH**/ ?>