<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>ترنسمیتال - <?php echo e($trans->transmittal_number); ?></title>
    <style>
        body {
            font-family: 'vazir', sans-serif;
            direction: rtl;
            padding: 20px;
            background-color: #f9f9f9;
        }

        h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 20px;
            border-bottom: 2px solid #ddd;
            padding-bottom: 10px;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }

        .label {
            font-weight: bold;
            width: 100px;
            min-width: 100px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 25px;
            background-color: #fff;
            box-shadow: 0 0 4px rgba(0,0,0,0.05);
        }

        th, td {
            border: 1px solid #ccc;
            padding: 10px;
            font-size: 12px;
            text-align: right;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .footer {
            margin-top: 40px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px dashed #ccc;
            padding-top: 10px;
        }

        .qr-code {
            text-align: center;
            margin-top: 30px;
        }
    </style>
</head>
<body>

<h2><?php echo e($trans->transmittal_number); ?></h2>

<div class="info-row">
    <div><span class="label">پروژه:</span> <?php echo e(optional($trans->project)->name ?? '-'); ?></div>
    <div><span class="label">فرستنده:</span> <?php echo e(optional($trans->sender)->name ?? '-'); ?></div>
    <div><span class="label">گیرنده:</span> <?php echo e(optional($trans->receiver)->name ?? '-'); ?></div>
</div>

<div class="info-row">
    <div><span class="label">هدف:</span> <?php echo e($trans->purpose ?? '-'); ?></div>
    <div><span class="label">توضیحات:</span> <?php echo e($trans->description ?? '-'); ?></div>
    <div><span class="label">تاریخ:</span> <?php echo e($trans->date ?? jdate($trans->created_at)->format('Y/m/d')); ?></div>
</div>

<!-- جدول مدارک -->
<h4 style="margin-top: 30px;">لیست مدارک ارسالی</h4>
<table>
    <thead>
    <tr>
        <th>#</th>
        <th>شماره سند</th>
        <th>عنوان</th>
        <th>ریویژن</th>
        <th>توضیحات</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $trans->documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e(optional($doc->masterDocument)->document_number ?? '-'); ?></td>
            <td><?php echo e(optional($doc->masterDocument)->title ?? '-'); ?></td>
            <td><?php echo e($doc->revision ?? '-'); ?></td>
            <td><?php echo e($doc->description ?? '-'); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<!-- گیرندگان CC -->
<?php if(optional($trans->recipients)->isNotEmpty()): ?>
    <h4 style="margin-top: 25px;">گیرندگان CC</h4>
    <ul style="list-style: none; padding: 0;">
        <?php $__currentLoopData = $trans->recipients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recipient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
                <?php echo e(optional($recipient->user)->name ?? 'نامشخص'); ?> (<?php echo e($recipient->role); ?>)
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>

<!-- QR Code -->
<div class="qr-code">
    <?php echo QrCode::size(200)->generate(route('transmittal.show', $trans->id)); ?>

</div>

<!-- Footer -->
<div class="footer">
    تولید شده در <?php echo e(now()->format('Y-m-d H:i')); ?>

</div>

</body>
</html><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\transmittal\transmittal-pdf.blade.php ENDPATH**/ ?>