<div>
    <div class="container py-4">
        <?php if(session()->has('success') || session()->has('error')): ?>
            <div class="alert <?php echo e(session()->has('success') ? 'alert-success' : 'alert-danger'); ?> rounded-4 shadow-sm mb-4" role="alert">
                <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-triangle'); ?> me-2"></i>
                <span class="fw-semibold"><?php echo e(session('success') ?? session('error')); ?></span>
            </div>
        <?php endif; ?>

        <div class="card shadow-lg border-0 rounded-4">
            <div class="card-header bg-dark-deep text-white rounded-top-4 p-4">
                <h4 class="fw-bold mb-0">
                    <i class="ti ti-handshake me-2"></i> تعیین طرفین قرارداد و مسئولین اصلی
                </h4>
            </div>
            <div class="card-body p-5">

                <form wire:submit.prevent="saveContractRoles">
                    <div class="row g-5">

                        <div class="col-md-6 border-end">
                            <h5 class="fw-bold text-action-primary mb-4 border-bottom pb-2">
                                <i class="ti ti-users me-2"></i> کارفرما و مشاور
                            </h5>

                            <div class="mb-5 pb-3 border-bottom">
                                <label class="form-label fw-bold text-primary-dark fs-5">کارفرمای اصلی</label>
                                <div class="mb-3">
                                    <select wire:model.live="main_client_id" class="form-select form-select-lg rounded-pill <?php $__errorArgs = ['main_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="">انتخاب شرکت...</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['main_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف کارفرما</label>
                                    <select wire:model.defer="main_client_user_id" class="form-select rounded-pill" <?php if(!$main_client_id): echo 'disabled'; endif; ?>>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        <?php $__currentLoopData = $mainClientUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['main_client_user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="form-label fw-bold text-primary-dark fs-5">مشاور پروژه</label>
                                <div class="mb-3">
                                    <select wire:model.live="consultant_id" class="form-select form-select-lg rounded-pill <?php $__errorArgs = ['consultant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="">انتخاب شرکت...</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['consultant_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف مشاور</label>
                                    <select wire:model.defer="consultant_user_id" class="form-select rounded-pill" <?php if(!$consultant_id): echo 'disabled'; endif; ?>>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        <?php $__currentLoopData = $consultantUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['consultant_user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h5 class="fw-bold text-danger-custom mb-4 border-bottom pb-2">
                                <i class="ti ti-hammer me-2"></i> پیمانکاران و سایر طرفین
                            </h5>

                            <div class="mb-5 pb-3 border-bottom">
                                <label class="form-label fw-bold text-primary-dark fs-5">پیمانکار اصلی</label>
                                <div class="mb-3">
                                    <select wire:model.live="contractor_id" class="form-select form-select-lg rounded-pill <?php $__errorArgs = ['contractor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="">انتخاب شرکت...</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['contractor_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف پیمانکار</label>
                                    <select wire:model.defer="contractor_user_id" class="form-select rounded-pill" <?php if(!$contractor_id): echo 'disabled'; endif; ?>>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        <?php $__currentLoopData = $contractorUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['contractor_user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <div class="mb-4">
                                <label class="form-label fw-bold text-primary-dark fs-5">کارفرمای فرعی (اختیاری)</label>
                                <div class="mb-3">
                                    <select wire:model.live="sub_client_id" class="form-select form-select-lg rounded-pill <?php $__errorArgs = ['sub_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="">انتخاب شرکت...</option>
                                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['sub_client_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="mt-3">
                                    <label class="form-label fw-medium small text-muted">مسئول تماس از طرف کارفرمای فرعی</label>
                                    <select wire:model.defer="sub_client_user_id" class="form-select rounded-pill" <?php if(!$sub_client_id): echo 'disabled'; endif; ?>>
                                        <option value="">انتخاب کاربر (عضو شرکت)...</option>
                                        <?php $__currentLoopData = $subClientUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['sub_client_user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end pt-4 border-top mt-4">
                        <button type="submit" class="btn btn-action-primary fw-bold rounded-pill px-5 py-2">
                            <span wire:loading.remove><i class="ti ti-device-floppy me-2"></i> ذخیره نقش‌های قراردادی</span>
                            <span wire:loading><span class="spinner-border spinner-border-sm me-2"></span> در حال ذخیره...</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <style>
        /* Custom Styles */
        .bg-dark-deep { background-color: #1A2538 !important; }
        .text-action-primary { color: #4361EE !important; }
        .text-danger-custom { color: #e74c3c !important; }
        .text-primary-dark { color: #1A2538 !important; }

        .card-header {
            background-color: #1A2538 !important;
        }

        .form-select-lg {
            padding: 0.75rem 1.5rem;
        }
        .btn-action-primary {
            background-color: #4361EE !important;
            border-color: #4361EE;
        }
        .btn-action-primary:hover {
            background-color: #3A4FCD !important;
        }
    </style>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\projects\project-contract-roles.blade.php ENDPATH**/ ?>