<div class="container-fluid py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-xl-9">

            
            <?php if(session()->has('success') || session()->has('error')): ?>
                <div
                    class="alert alert-<?php echo e(session()->has('success') ? 'success' : 'danger'); ?> alert-dismissible fade show d-flex align-items-center mb-4 border-0 shadow-sm rounded-4 notification-alert"
                    role="alert"
                >
                    <i class="ti ti-<?php echo e(session()->has('success') ? 'check-circle' : 'alert-octagon'); ?> fs-4 me-3"></i>
                    <div class="flex-grow-1 fw-medium">
                        <?php echo e(session('success') ?? session('error')); ?>

                    </div>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            
            <div class="post-header-card rounded-4 shadow-lg overflow-hidden mb-4 position-relative text-white">
                <div class="p-4 p-md-5 position-relative">

                    <?php if($post->category): ?>
                        <span class="badge rounded-pill bg-white bg-opacity-20 px-3 py-2 mb-3 d-inline-flex align-items-center gap-1 small">
                            <i class="ti ti-tag"></i>
                            <?php echo e($post->category->name); ?>

                        </span>
                    <?php endif; ?>

                    <h1 class="fw-bold display-6 mb-3"><?php echo e($post->title); ?></h1>

                    <div class="d-flex flex-wrap align-items-center gap-3 small opacity-90">
                        <div>
                            <i class="ti ti-user-circle me-1"></i>
                            <?php echo e($post->author->name ?? 'بدون نویسنده'); ?>

                        </div>

                        <div>
                            <i class="ti ti-calendar-event me-1"></i>
                            <?php echo e($post->created_at->translatedFormat('j F Y')); ?>

                        </div>

                        <div class="text-white-50">
                            • <?php echo e($post->created_at->diffForHumans()); ?>

                        </div>
                    </div>

                    <div class="header-bg-icon">
                        <i class="ti ti-news"></i>
                    </div>
                </div>
            </div>

            
            <div class="bg-white rounded-4 shadow-sm p-4 p-md-5 content-wrapper">

                
                <?php if($post->image): ?>
                    <div class="hero-image-wrapper rounded-4 overflow-hidden mb-4">
                        <img src="<?php echo e(asset('storage/' . $post->image)); ?>"
                             class="img-fluid hero-image"
                             alt="<?php echo e($post->title); ?>">
                    </div>
                <?php endif; ?>

                
                <div class="d-flex flex-wrap align-items-center justify-content-between gap-2 mb-4">
                    <div class="d-flex flex-wrap align-items-center gap-2">

                        
                        <button
                            type="button"
                            wire:click="toggleLike"
                            wire:loading.attr="disabled"
                            class="btn btn-sm rounded-pill like-pill d-inline-flex align-items-center gap-1"
                        >
                            <i class="ti ti-heart<?php echo e($liked ? '' : '-plus'); ?> fs-5 <?php echo e($liked ? 'text-danger' : ''); ?>"></i>
                            <span class="small">
                                <?php echo e($likesCount); ?> لایک
                            </span>
                        </button>

                        
                        <div class="badge rounded-pill bg-gray-100 text-secondary d-inline-flex align-items-center gap-1 small">
                            <i class="ti ti-message-circle fs-6"></i>
                            <?php echo e($commentsCount); ?> دیدگاه
                        </div>

                        
                        <?php if($post->media_file): ?>
                            <a href="<?php echo e(asset('storage/' . $post->media_file)); ?>"
                               class="badge rounded-pill bg-primary-subtle text-primary d-inline-flex align-items-center gap-1 small text-decoration-none"
                               target="_blank">
                                <i class="ti ti-paperclip fs-6"></i>
                                فایل پیوست
                            </a>
                        <?php endif; ?>
                    </div>

                    <div class="d-flex flex-wrap align-items-center gap-2">
                        <a href="<?php echo e(route('user.posts')); ?>"
                           class="btn btn-sm btn-light rounded-pill px-3 d-inline-flex align-items-center gap-1 hover-scale shadow-sm">
                            <i class="ti ti-arrow-right fs-5"></i>
                            بازگشت
                        </a>

                        <?php if(auth()->check() && auth()->user()->isAdmin()): ?>
                            <a href="<?php echo e(route('admin.posts.edit', $post->id)); ?>"
                               class="btn btn-sm btn-primary rounded-pill px-3 d-inline-flex align-items-center gap-1 hover-scale shadow-md">
                                <i class="ti ti-edit fs-5"></i>
                                ویرایش
                            </a>
                        <?php endif; ?>
                    </div>
                </div>

                
                <div class="post-content fs-6 lh-lg text-gray-700 mb-4">
                    <?php echo nl2br(e($post->content)); ?>

                </div>

                
                <hr class="my-4">

                
                <div class="comments-section">

                    <div class="d-flex align-items-center justify-content-between mb-3">
                        <div class="d-flex align-items-center gap-2">
                            <div class="comments-icon-pill">
                                <i class="ti ti-message-circle"></i>
                            </div>
                            <div>
                                <div class="fw-semibold">دیدگاه‌ها</div>
                                <div class="small text-muted">
                                    <?php echo e($commentsCount); ?> دیدگاه ثبت شده
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="comment-form-card mb-4 p-3 p-md-4 rounded-3 border bg-gray-50">
                        <?php if(auth()->check()): ?>
                            <form wire:submit.prevent="addComment" class="d-flex flex-column gap-3">

                                <div class="d-flex align-items-start gap-2 mb-1">
                                    <div class="comment-avatar">
                                        <span>
                                            <?php echo e(mb_substr(auth()->user()->name ?? 'شما', 0, 1)); ?>

                                        </span>
                                    </div>
                                    <div class="flex-grow-1">
                                        <label for="commentBody" class="form-label small text-muted mb-1">
                                            نظر خود را درباره این پست بنویسید
                                        </label>
                                        <textarea
                                            id="commentBody"
                                            rows="3"
                                            class="form-control rounded-3 <?php $__errorArgs = ['commentBody'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            placeholder="متن دیدگاه شما..."
                                            wire:model.defer="commentBody"
                                        ></textarea>
                                        <?php $__errorArgs = ['commentBody'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback d-block small mt-1"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button
                                        type="submit"
                                        class="btn btn-primary rounded-pill px-4 d-inline-flex align-items-center gap-2"
                                        wire:loading.attr="disabled"
                                        wire:target="addComment"
                                    >
                                        <span wire:loading.remove wire:target="addComment">
                                            <i class="ti ti-send fs-5"></i>
                                            ارسال دیدگاه
                                        </span>
                                        <span wire:loading wire:target="addComment">
                                            <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                            در حال ارسال...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        <?php else: ?>
                            <div class="d-flex align-items-center gap-2 small text-muted">
                                <i class="ti ti-lock fs-5"></i>
                                برای ارسال دیدگاه، ابتدا وارد حساب کاربری خود شوید.
                            </div>
                        <?php endif; ?>
                    </div>

                    
                    <?php if($comments->count() > 0): ?>
                        <div class="comments-list d-flex flex-column gap-3">
                            <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="comment-item p-3 rounded-3 border bg-white shadow-sm-sm">
                                    <div class="d-flex align-items-start gap-2">
                                        <div class="comment-avatar small-avatar">
                                            <span>
                                                <?php echo e(mb_substr($comment->user->name ?? '؟', 0, 1)); ?>

                                            </span>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="fw-semibold small">
                                                    <?php echo e($comment->user->name ?? 'کاربر'); ?>

                                                </div>
                                                <div class="small text-muted">
                                                    <?php echo e($comment->created_at->diffForHumans()); ?>

                                                </div>
                                            </div>
                                            <div class="text-gray-700 small lh-lg">
                                                <?php echo e($comment->body); ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        
                        <?php if($comments->hasPages()): ?>
                            <div class="mt-3">
                                <?php echo e($comments->links('pagination.custom-modern')); ?>

                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="text-center text-muted small py-3">
                            هنوز دیدگاهی ثبت نشده است. اولین نفر باشید 🤍
                        </div>
                    <?php endif; ?>

                </div>

            </div>
        </div>
    </div>

    
    <style>
        :root {
            --primary: #0f766e;
            --primary-dark: #115e59;
            --gray-50: #f9fafb;
            --gray-100: #f3f4f6;
            --gray-700: #374151;
        }

        .notification-alert {
            background: linear-gradient(135deg, #10b981, #059669) !important;
            color: #fff !important;
        }
        .btn-close-white { filter: brightness(0) invert(1); }

        .post-header-card {
            background: radial-gradient(circle at top left, rgba(255,255,255,0.18), transparent 40%),
            linear-gradient(135deg, var(--primary-dark), var(--primary));
        }

        .header-bg-icon {
            position: absolute;
            left: -10px;
            top: -10px;
            font-size: 9rem;
            opacity: 0.07;
            transform: rotate(-15deg);
        }

        .content-wrapper {
            font-size: 1rem;
        }

        .hero-image-wrapper .hero-image {
            width: 100%;
            height: 350px;
            object-fit: cover;
            transition: all 0.25s ease-in-out;
        }
        .hero-image-wrapper:hover .hero-image {
            transform: scale(1.03);
        }

        .post-content {
            color: var(--gray-700);
        }
        .post-content p {
            margin-bottom: 1rem;
        }

        .hover-scale {
            transition: transform .15s ease, box-shadow .15s ease;
        }
        .hover-scale:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 12px rgba(0,0,0,0.12);
        }

        .bg-gray-50 { background-color: var(--gray-50); }
        .bg-gray-100 { background-color: var(--gray-100); }

        .like-pill {
            background-color: #fee2e2;
            color: #b91c1c;
            border: none;
        }
        .like-pill:hover {
            background-color: #fecaca;
        }

        .comments-icon-pill {
            width: 34px;
            height: 34px;
            border-radius: 999px;
            background: rgba(59, 130, 246, 0.12);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            color: #1d4ed8;
        }

        .comment-avatar {
            width: 38px;
            height: 38px;
            border-radius: 999px;
            background: #e5e7eb;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            color: #374151;
        }
        .comment-avatar.small-avatar {
            width: 32px;
            height: 32px;
            font-size: 0.8rem;
        }

        .shadow-sm-sm {
            box-shadow: 0 3px 10px rgba(15, 23, 42, 0.06);
        }
    </style>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\user\post-show.blade.php ENDPATH**/ ?>