<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-gradient-primary-to-secondary d-flex justify-content-between align-items-center">
            <h4 class="mb-0 text-white">مشاهده مدرک</h4>
            <a href="<?php echo e(route('admin.mdr.list', $doc->project_id)); ?>" class="btn btn-sm btn-outline-light">بازگشت</a>
        </div>
        <div class="card-body">

            <dl class="row g-3">
                <dt class="col-md-3 fw-bold">شماره سند:</dt>
                <dd class="col-md-9"><?php echo e($doc->document_number); ?></dd>

                <dt class="col-md-3 fw-bold">عنوان:</dt>
                <dd class="col-md-9"><?php echo e($doc->title); ?></dd>

                <dt class="col-md-3 fw-bold">پروژه:</dt>
                <dd class="col-md-9"><?php echo e(optional($doc->project)->name ?? '-'); ?></dd>

                <dt class="col-md-3 fw-bold">رشته:</dt>
                <dd class="col-md-9"><?php echo e(optional($doc->discipline)->name ?? '-'); ?></dd>

                <dt class="col-md-3 fw-bold">نوع مدرک:</dt>
                <dd class="col-md-9"><?php echo e($doc->document_type); ?></dd>

                <dt class="col-md-3 fw-bold">آخرین رویژن:</dt>
                <dd class="col-md-9"><?php echo e($doc->revision ?? '-'); ?></dd>

                <dt class="col-md-3 fw-bold">وضعیت:</dt>
                <dd class="col-md-9">
                    <?php switch($doc->status):
                        case ('valid'): ?>
                            <span class="badge bg-success">معتبر</span>
                            <?php break; ?>
                        <?php case ('obsolete'): ?>
                            <span class="badge bg-danger">منقضی شده</span>
                            <?php break; ?>
                        <?php default: ?>
                            <span class="badge bg-warning text-dark">نامشخص</span>
                    <?php endswitch; ?>
                </dd>
            </dl>

            <hr>

            <!-- لیست ترنسمیتال‌ها -->
            <h6>لیست ترنسمیتال‌های این مدرک</h6>
            <?php if($doc->transmittals->isNotEmpty()): ?>
                <table class="table table-bordered table-sm mb-4">
                    <thead>
                    <tr>
                        <th>شماره ترنسمیتال</th>
                        <th>فرستنده</th>
                        <th>گیرنده</th>
                        <th>تاریخ</th>
                        <th>هدف</th>
                        <th>وضعیت</th>
                        <th>PDF</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $doc->transmittals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($t->transmittal_number); ?></td>
                            <td><?php echo e(optional($t->sender)->name); ?></td>
                            <td><?php echo e(optional($t->receiver)->name); ?></td>
                            <td><?php echo e(jdate($t->created_at)->format('Y/m/d')); ?></td>
                            <td><?php echo e($t->purpose); ?></td>
                            <td>
                                <?php switch($t->status):
                                    case ('sent'): ?> <span class="badge bg-success">ارسال شده</span> <?php break; ?>
                                    <?php case ('received'): ?> <span class="badge bg-info">دریافت شده</span> <?php break; ?>
                                    <?php case ('rejected'): ?> <span class="badge bg-danger">رد شده</span> <?php break; ?>
                                    <?php default: ?> <span class="badge bg-warning text-dark">در انتظار</span>
                                <?php endswitch; ?>
                            </td>
                            <td>
                                <a href="<?php echo e(route('transmittal.download', $t->id)); ?>" target="_blank" class="btn btn-sm btn-success">
                                    <i class="fas fa-file-pdf"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted">بدون ترنسمیتال</p>
            <?php endif; ?>

        </div>
    </div>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\m-d-r\show-mdr.blade.php ENDPATH**/ ?>