<div class="container-fluid py-4" x-data="{ bulkMode: false, selectedRequests: <?php if ((object) ('selectedRequests') instanceof \Livewire\WireDirective) : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('selectedRequests'->value()); ?>')<?php echo e('selectedRequests'->hasModifier('live') ? '.live' : ''); ?><?php else : ?>window.Livewire.find('<?php echo e($__livewire->getId()); ?>').entangle('<?php echo e('selectedRequests'); ?>')<?php endif; ?>, expandedRow: null }">
    <style>
        .fw-black { font-weight: 900 !important; }
        .smaller-8 { font-size: 0.8rem; }
        .bg-light-primary { background-color: #f1f3ff !important; }
        .bg-light-success { background-color: #e8fff3 !important; }
        .transition-all { transition: all 0.3s ease; }
        .rounded-5 { border-radius: 2rem !important; }
        .avatar-lux { border: 2px solid #fff; object-fit: cover; }
        .shadow-2xl { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important; }
        .signature-box { min-height: 100px; display: flex; align-items: center; justify-content: center; border-radius: 15px; background: #fcfcfc; }
    </style>

    
    <div class="card border-0 shadow-sm mb-4 no-print" style="border-radius: 20px; background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%); color: white;">
        <div class="card-body p-4">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center">
                    <div class="p-3 bg-white bg-opacity-10 rounded-4 me-4 shadow-lg">
                        <i class="ti ti-building-skyscraper fs-1 text-info"></i>
                    </div>
                    <div>
                        <h3 class="fw-black mb-1 text-white">تدارکات پروژه: <?php echo e($this->project->name); ?></h3>
                        <p class="mb-0 opacity-75 fw-bold smaller-8 text-info">مدیریت و نظارت بر درخواست‌های خرید اختصاصی این کارگاه</p>
                    </div>
                </div>
                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('admin.purchase_request', ['project_id' => $projectId])); ?>" class="btn btn-info rounded-pill px-4 fw-black shadow-lg border-0 text-dark">
                        <i class="ti ti-plus me-2"></i>ثبت درخواست جدید
                    </a>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card border-0 shadow-sm mb-4 rounded-4 no-print">
        <div class="card-body p-4">
            <div class="row g-3 align-items-end">
                <div class="col-md-5">
                    <label class="form-label fw-black smaller-8 text-muted mb-2 pe-2">جستجو در این پروژه</label>
                    <div class="input-group shadow-sm rounded-3 overflow-hidden border">
                        <span class="input-group-text bg-white border-0"><i class="ti ti-search text-muted"></i></span>
                        <input type="text" class="form-control border-0 ps-2 fw-bold" wire:model.live.debounce.300ms="search" placeholder="کد PR، کالا یا متقاضی...">
                    </div>
                </div>
                <div class="col-md-3">
                    <label class="form-label fw-black smaller-8 text-muted mb-2 pe-2">وضعیت</label>
                    <select class="form-select border shadow-sm rounded-3 fw-bold" wire:model.live="statusFilter">
                        <option value="">همه وضعیت‌ها</option>
                        <option value="pending">⏳ در انتظار</option>
                        <option value="approved">✅ تایید شده</option>
                        <option value="rejected">❌ رد شده</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label fw-black smaller-8 text-muted mb-2 pe-2">متقاضی</label>
                    <select class="form-select border shadow-sm rounded-3 fw-bold" wire:model.live="userFilter">
                        <option value="">همه افراد</option>
                        <?php $__currentLoopData = $this->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2 text-end">
                    <button wire:click="resetFilters" class="btn btn-light w-100 rounded-3 fw-black border py-2 shadow-sm">
                        <i class="ti ti-refresh"></i> بازنشانی
                    </button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="card border-0 shadow-lg rounded-4 overflow-hidden no-print">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead class="bg-dark text-white">
                <tr>
                    <th class="py-3 px-4">اطلاعات پرونده</th>
                    <th class="py-3">متقاضی ثبت</th>
                    <th class="py-3 text-center">مبلغ برآورد</th>
                    <th class="py-3 text-center">وضعیت تایید</th>
                    <th class="py-3 text-center">عملیات</th>
                </tr>
                </thead>
                <tbody class="bg-white">
                <?php $__empty_1 = true; $__currentLoopData = $this->purchaseRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $approvedCount = $request->approvals->where('is_approved', true)->count();
                        $totalApprovals = $request->approvals->count();
                        $percent = $totalApprovals > 0 ? ($approvedCount / $totalApprovals) * 100 : 0;
                    ?>
                    <tr :class="expandedRow === <?php echo e($request->id); ?> ? 'bg-light-primary' : ''" class="transition-all">
                        <td class="px-4">
                            <div class="d-flex align-items-center">
                                <button @click="expandedRow = (expandedRow === <?php echo e($request->id); ?> ? null : <?php echo e($request->id); ?>)" class="btn btn-sm btn-icon btn-white border rounded-circle me-3 shadow-sm">
                                    <i class="ti text-primary fs-5" :class="expandedRow === <?php echo e($request->id); ?> ? 'ti-minus' : 'ti-plus'"></i>
                                </button>
                                <div>
                                    <div class="fw-black text-dark fs-6">PR-<?php echo e($request->id); ?></div>
                                    <small class="text-muted fw-bold"><?php echo e(jdate($request->created_at)->format('Y/m/d')); ?></small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <img src="<?php echo e($request->user->image ? asset('storage/' . $request->user->image) : 'https://ui-avatars.com/api/?name=' . urlencode($request->user->name) . '&background=f1f5f9&color=6366f1&bold=true'); ?>" class="rounded-4 me-3 avatar-lux shadow-sm" width="35" height="35">
                                <span class="fw-black text-dark smaller-8"><?php echo e($request->user->name); ?></span>
                            </div>
                        </td>
                        <td class="text-center fw-black text-primary fs-5"><?php echo e(number_format($request->total_price)); ?></td>
                        <td class="text-center">
                            <div class="progress mb-1 shadow-sm" style="height: 6px; border-radius: 10px; background: #eee;">
                                <div class="progress-bar bg-success progress-bar-striped progress-bar-animated" style="width: <?php echo e($percent); ?>%"></div>
                            </div>
                            <span class="smaller-8 fw-black text-muted"><?php echo e($approvedCount); ?> از <?php echo e($totalApprovals); ?> مرحله</span>
                        </td>
                        <td class="text-center">
                            <div class="d-flex justify-content-center gap-2">
                                <button class="btn btn-icon btn-white border btn-sm rounded-circle shadow-sm" data-bs-toggle="modal" data-bs-target="#detailModal<?php echo e($request->id); ?>">
                                    <i class="ti ti-file-search fs-5 text-primary"></i>
                                </button>
                                <button class="btn btn-icon btn-white border btn-sm rounded-circle shadow-sm" wire:click="downloadPdf(<?php echo e($request->id); ?>)">
                                    <i class="ti ti-download fs-5 text-danger"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    
                    <tr x-show="expandedRow === <?php echo e($request->id); ?>" x-cloak x-transition>
                        <td colspan="5" class="p-0 border-0">
                            <div class="px-5 py-4 bg-light-primary border-start border-primary border-5 mx-4 my-2 rounded-4 shadow-inner">
                                <div class="row">
                                    <div class="col-md-7">
                                        <h6 class="fw-black mb-3 text-primary smaller-8">اقلام کلیدی درخواست:</h6>
                                        <div class="bg-white rounded-3 overflow-hidden shadow-sm">
                                            <table class="table table-sm mb-0">
                                                <thead class="bg-light">
                                                <tr><th class="ps-3 py-2">نام کالا</th><th class="text-center">تعداد</th></tr>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr><td class="ps-3 small"><?php echo e($item->displayName); ?></td><td class="text-center fw-black text-primary small"><?php echo e($item->quantity); ?></td></tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <h6 class="fw-black mb-3 text-primary smaller-8">شرح ضرورت:</h6>
                                        <div class="p-3 bg-white rounded-3 shadow-sm small fw-bold text-muted leading-relaxed">
                                            <?php echo e($request->description ?: 'توضیحاتی ثبت نشده است.'); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="5" class="text-center py-5 opacity-50 fw-black text-muted">درخواستی یافت نشد.</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="card-footer bg-white border-0 p-4"><?php echo e($this->purchaseRequests->links()); ?></div>
    </div>

    
    <?php $__currentLoopData = $this->purchaseRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="detailModal<?php echo e($request->id); ?>" tabindex="-1" wire:ignore.self>
            <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content border-0 rounded-5 shadow-2xl overflow-hidden">

                    <div class="modal-header bg-dark text-white p-4 border-0">
                        <div class="d-flex align-items-center">
                            <div class="p-3 bg-primary rounded-4 me-3">
                                <i class="ti ti-file-certificate fs-2 text-white"></i>
                            </div>
                            <div>
                                <h4 class="fw-black mb-1">جزئیات پرونده PR-<?php echo e($request->id); ?></h4>
                                <span class="fw-bold opacity-75 smaller-8">ثبت شده در: <?php echo e(jdate($request->created_at)->format('Y/m/d H:i')); ?></span>
                            </div>
                        </div>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body p-0 bg-light-subtle">
                        
                        <div class="p-4 bg-white border-bottom shadow-sm mx-3 mt-3 rounded-4">
                            <div class="row g-4 align-items-center">
                                <div class="col-md-3">
                                    <small class="text-muted d-block mb-1 fw-bold">متقاضی</small>
                                    <span class="fw-black text-dark"><?php echo e($request->user->name); ?></span>
                                </div>
                                <div class="col-md-3 border-start-md ps-md-4">
                                    <small class="text-muted d-block mb-1 fw-bold">ارزش کل برآورد</small>
                                    <span class="fw-black text-primary fs-5"><?php echo e(number_format($request->total_price)); ?> <small class="smaller-8">ریال</small></span>
                                </div>
                                <div class="col-md-3 border-start-md ps-md-4">
                                    <small class="text-muted d-block mb-1 fw-bold">وضعیت نهایی</small>
                                    <span class="badge bg-<?php echo e($request->status == 'approved' ? 'success' : ($request->status == 'rejected' ? 'danger' : 'warning')); ?> rounded-pill px-3"><?php echo e($request->status); ?></span>
                                </div>
                                <div class="col-md-3 border-start-md text-end">
                                    <button wire:click="downloadPdf(<?php echo e($request->id); ?>)" class="btn btn-danger btn-sm rounded-pill px-3 fw-black">
                                        <i class="ti ti-file-type-pdf me-1"></i> PDF رسمی
                                    </button>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion accordion-flush p-3" id="modalAcc<?php echo e($request->id); ?>">

                            
                            <div class="accordion-item rounded-4 mb-3 border shadow-sm overflow-hidden">
                                <h2 class="accordion-header">
                                    <button class="accordion-button fw-black py-3 bg-white shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#m-items<?php echo e($request->id); ?>">
                                        <i class="ti ti-package me-2 text-primary"></i> ریز اقلام کالا و خدمات
                                    </button>
                                </h2>
                                <div id="m-items<?php echo e($request->id); ?>" class="accordion-collapse collapse show" data-bs-parent="#modalAcc<?php echo e($request->id); ?>">
                                    <div class="accordion-body p-0">
                                        <table class="table table-hover align-middle mb-0">
                                            <thead class="bg-light">
                                            <tr class="smaller-8 fw-black text-center">
                                                <th>ردیف</th><th>شرح</th><th>مقدار</th><th>فی</th><th>جمع</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $request->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="text-center fw-bold small">
                                                    <td><?php echo e($idx + 1); ?></td>
                                                    <td class="text-end"><?php echo e($item->displayName); ?></td>
                                                    <td><?php echo e($item->quantity); ?></td>
                                                    <td><?php echo e(number_format($item->price)); ?></td>
                                                    <td class="text-primary fw-black"><?php echo e(number_format($item->subtotal)); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="accordion-item rounded-4 border shadow-sm overflow-hidden">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed fw-black py-3 bg-white shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#m-workflow<?php echo e($request->id); ?>">
                                        <i class="ti ti-git-fork me-2 text-primary"></i> تاریخچه تاییدات و امضای مدیران
                                    </button>
                                </h2>
                                <div id="m-workflow<?php echo e($request->id); ?>" class="accordion-collapse collapse" data-bs-parent="#modalAcc<?php echo e($request->id); ?>">
                                    <div class="accordion-body bg-white p-4">
                                        <div class="row g-4 justify-content-center">
                                            <?php $__currentLoopData = $request->approvals->sortBy('priority'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-md-4">
                                                    <div class="card border shadow-sm rounded-4 p-3 h-100 <?php echo e($approval->is_approved === true ? 'bg-light-success border-success border-opacity-25' : 'bg-light border-secondary border-opacity-10'); ?>">
                                                        <div class="text-center mb-3">
                                                            <small class="fw-black text-muted d-block"><?php echo e($approval->role->name); ?></small>
                                                            <span class="fw-bold text-dark"><?php echo e($approval->user->name ?? '---'); ?></span>
                                                        </div>
                                                        <div class="signature-box position-relative overflow-hidden">
                                                            <?php if($approval->is_approved === true): ?>
                                                                <img src="https://i.postimg.cc/mD7Q3rM2/approved-stamp.png" style="width: 70px; position: absolute; top: 0; right: 0; opacity: 0.2; transform: rotate(-15deg);">
                                                                <?php if($approval->user->sign): ?>
                                                                    <img src="<?php echo e(asset('storage/' . $approval->user->sign)); ?>" style="max-height: 70px; max-width: 100%; filter: contrast(110%) sepia(100%) hue-rotate(190deg) saturate(200%);" alt="Sign">
                                                                <?php else: ?>
                                                                    <div class="text-primary opacity-50 fw-black italic">تایید سیستمی</div>
                                                                <?php endif; ?>
                                                            <?php elseif($approval->is_approved === false): ?>
                                                                <div class="text-danger fw-black border border-danger border-2 p-2 rounded-3 small" style="transform: rotate(-5deg); border-style: dashed !important;">رد درخواست</div>
                                                            <?php else: ?>
                                                                <div class="text-muted opacity-25 fw-bold small py-3"><i class="ti ti-clock me-1"></i>در انتظار...</div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="text-center mt-2">
                                                            <small class="text-muted fs-xs fw-bold"><?php echo e($approval->approved_at ? jdate($approval->approved_at)->format('Y/m/d H:i') : ''); ?></small>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        
                        <?php
                            $userApproval = $request->approvals->where('user_id', auth()->id())->whereNull('is_approved')->first();
                        ?>
                        <?php if($userApproval && $request->status == 'pending'): ?>
                            <div class="p-4 bg-light-primary border-top m-3 rounded-4 border border-primary border-opacity-25">
                                <div class="row align-items-center">
                                    <div class="col-md-7">
                                        <label class="fw-black text-primary mb-2 small">یادداشت یا توضیحات مدیریتی:</label>
                                        <textarea wire:model="comment" class="form-control border-0 shadow-sm rounded-3 p-3 fw-bold small" rows="2" placeholder="دلیل تایید یا رد را بنویسید..."></textarea>
                                    </div>
                                    <div class="col-md-5 text-end pt-3">
                                        <button wire:click="rejectRequest(<?php echo e($request->id); ?>)" class="btn btn-danger rounded-pill px-4 fw-black shadow-sm me-2">رد درخواست</button>
                                        <button wire:click="approveRequest(<?php echo e($request->id); ?>)" class="btn btn-success rounded-pill px-4 fw-black shadow-sm">تایید و امضا</button>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="modal-footer bg-white border-0 justify-content-center pb-4 pt-0">
                        <button type="button" class="btn btn-secondary rounded-pill px-5 fw-black shadow-sm" data-bs-dismiss="modal">بستن پرونده</button>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\purchase\project-purchase-requests.blade.php ENDPATH**/ ?>