<div>
    <div class="container-fluid py-4">

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show rounded-3 shadow-lg mb-4" role="alert">
                <i class="ti ti-check me-2"></i>
                <span class="fw-semibold"><?php echo e(session('success')); ?></span>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="card shadow-2xl border-0 rounded-4 mb-5 card-hover-effect">
            <div class="card-header bg-action-primary text-white rounded-top-4 py-3">
                <h4 class="fw-semibold mb-0">
                    <i class="ti ti-user-shield me-2"></i> <?php echo e($isEditMode ? 'ویرایش نقش' : 'ثبت نقش جدید'); ?>

                </h4>
            </div>
            <div class="card-body p-4 p-md-5">

                <form wire:submit.prevent="<?php echo e($isEditMode ? 'updateRole' : 'saveRole'); ?>">
                    <div class="row g-4">

                        <div class="col-12 col-md-6">
                            <label for="label" class="form-label fw-medium text-primary-dark">نام نمایشی (فارسی):</label>
                            <input
                                type="text"
                                class="form-control form-control-lg <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                wire:model.live.debounce.300ms="label"
                                id="label"
                                placeholder="مثال: مدیر اصلی پروژه"
                            >
                            <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-12 col-md-6">
                            <label for="name" class="form-label fw-medium text-primary-dark">نام فنی (سیستمی):</label>
                            <input
                                type="text"
                                class="form-control form-control-lg <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                wire:model.live.debounce.300ms="name"
                                id="name"
                                placeholder="مثال: project_manager"
                            >
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-12 mt-3">
                            <div class="form-check form-switch fs-5">
                                <input
                                    class="form-check-input"
                                    type="checkbox"
                                    role="switch"
                                    id="isProjectRoleSwitch"
                                    wire:model.defer="isProjectRole"
                                    style="height: 1.5em; width: 3em;"
                                >
                                <label class="form-check-label fw-medium text-primary-dark" for="isProjectRoleSwitch">
                                    آیا این نقش برای پروژه‌ها قابل تخصیص است؟
                                </label>
                            </div>
                            <?php $__errorArgs = ['isProjectRole'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small mt-1"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="col-12 mt-3 d-flex align-items-center gap-3">
                            <button type="submit" class="btn btn-action-primary font-medium rounded-pill px-5 py-2" wire:loading.attr="disabled">
                                <div class="d-flex align-items-center">
                                    <i class="ti ti-<?php echo e($isEditMode ? 'refresh' : 'send'); ?> me-2 fs-4" wire:loading.remove></i>
                                    <span wire:loading.remove wire:target="<?php echo e($isEditMode ? 'updateRole' : 'saveRole'); ?>"><?php echo e($isEditMode ? 'بروزرسانی نقش' : 'ثبت نقش'); ?></span>
                                    <span wire:loading wire:target="<?php echo e($isEditMode ? 'updateRole' : 'saveRole'); ?>">
                                    <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                    در حال پردازش...
                                </span>
                                </div>
                            </button>

                            <?php if($isEditMode): ?>
                                <button type="button" wire:click="resetInput" class="btn btn-outline-secondary font-medium rounded-pill px-5 py-2">
                                    انصراف از ویرایش
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card shadow-lg rounded-4 overflow-hidden">
            <div class="card-header bg-light border-bottom py-3">
                <h5 class="fw-semibold mb-0 text-primary-dark">
                    <i class="ti ti-list me-2"></i> لیست نقش‌های موجود در سیستم
                </h5>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle mb-0">
                        <thead class="bg-deep-blue text-white shadow-sm">
                        <tr>
                            <th class="py-3 px-4 fw-bold" style="width: 25%;">نام نمایشی</th>
                            <th class="py-3 px-4 fw-bold" style="width: 25%;">نام فنی (Code)</th>
                            <th class="py-3 px-4 fw-bold text-center" style="width: 20%;">نقش پروژه‌ای</th>
                            <th class="py-3 px-4 fw-bold text-center" style="width: 30%;">عملیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="table-row-hover">
                                <td class="px-4 fw-bold text-primary-dark fs-6"><?php echo e($role->label ?? '---'); ?></td>
                                <td class="px-4 fw-medium text-muted fs-6"><code><?php echo e($role->name); ?></code></td>
                                <td class="text-center">
                                    <?php if($role->is_project_role): ?>
                                        <span class="badge bg-success-light text-success fw-bold p-2">
                                            <i class="ti ti-check me-1"></i> بله
                                        </span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary-light text-secondary fw-bold p-2">
                                            <i class="ti ti-x me-1"></i> خیر
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex justify-content-center gap-2">
                                        <button wire:click="editRole(<?php echo e($role->id); ?>)" class="btn btn-sm btn-action-secondary-light text-dark rounded-pill px-3 py-2" title="ویرایش">
                                            <i class="ti ti-edit fs-5"></i>
                                        </button>
                                        <button wire:click="deleteRole(<?php echo e($role->id); ?>)"
                                                wire:confirm="آیا مطمئن هستید که نقش <?php echo e($role->label ?? $role->name); ?> حذف شود؟"
                                                class="btn btn-sm btn-danger rounded-pill px-3 py-2" title="حذف">
                                            <i class="ti ti-trash fs-5"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="text-center py-4 text-muted fw-medium">
                                    <i class="ti ti-info-circle me-2"></i> نقشی برای نمایش وجود ندارد.
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <style>
        /* Color Palettes */
        :root {
            --primary-dark: #1A2538;
            --action-color: #4361EE;
            --action-dark: #3A4FCD;
            --action-secondary: #00BF63;
            --action-secondary-light: #E0F7EB;
        }
        /* Gradient & Custom Colors */
        .bg-deep-blue { background-color: var(--primary-dark) !important; }
        .bg-action-primary { background-color: var(--action-color) !important; }
        .btn-action-primary { background-color: var(--action-color) !important; border-color: var(--action-color); color: white; transition: all 0.2s; }
        .btn-action-primary:hover { background-color: var(--action-dark) !important; border-color: var(--action-dark) !important; }
        .text-primary-dark { color: var(--primary-dark) !important; }
        .btn-action-secondary-light { background-color: var(--action-secondary-light) !important; border-color: var(--action-secondary-light); color: var(--primary-dark) !important; }
        .btn-action-secondary-light:hover { background-color: #C8F0DD !important; border-color: #C8F0DD !important; }

        /* Custom Badges */
        .bg-success-light { background-color: var(--action-secondary-light); }
        .text-success { color: var(--action-secondary) !important; }
        .bg-secondary-light { background-color: #e9ecef; }
        .text-secondary { color: #6c757d !important; }

        /* Card & Table Aesthetics */
        .card-hover-effect { transition: transform 0.3s ease, box-shadow 0.3s ease; }
        .card-hover-effect:hover { transform: translateY(-3px); box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1) !important; }
        .table-responsive { border-radius: 0.75rem; }
        .table-hover .table-row-hover:hover { background-color: #f0f4ff; box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05); }
        .form-control-lg { height: calc(3.5rem + 2px); }
    </style>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\roles\add-roles.blade.php ENDPATH**/ ?>