<div class="container-xxl px-5 py-4">
    <!-- Toast Notification (Modern & Clean) -->
    <div x-data="{ open: false, message: '', type: 'success' }"
         x-show="open"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0 transform translate-y-2"
         x-transition:enter-end="opacity-100 transform translate-y-0"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100 transform translate-y-0"
         x-transition:leave-end="opacity-0 transform translate-y-2"
         <?php echo $__env->yieldSection(); ?>-toast.window="open = true; message = $event.detail.message; type = $event.detail.type || 'success'; setTimeout(() => { open = false }, 4000)"
         class="fixed top-0 left-1/2 -translate-x-1/2 z-[100] p-4 flex items-start justify-center pointer-events-none"
         style="z-index: 1000; width: 400px;">
        <div x-text="message"
             :class="{
                 'alert-success': type === 'success',
                 'alert-danger': type === 'error'
             }"
             class="alert alert-dismissible fade show rounded-pill text-center px-4 py-3 shadow-lg pointer-events-auto"
             role="alert">
        </div>
    </div>

    <!-- پیام موفقیت سنتی (برای نمایش بعد از Redirect) -->
    <?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show rounded-pill text-center px-4 py-3 mb-4 shadow-lg">
            <i class="ti ti-check-circle me-2"></i><?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <form wire:submit.prevent="saveLetter" enctype="multipart/form-data"
          class="modern-letter-form card border-0 shadow-2xl px-3 px-md-5 py-5 mx-auto" style="max-width: 1400px; border-radius: 1.5rem;">

        <!-- Stepper (Modern Look) -->
        <div class="stepper mb-6 d-flex align-items-center justify-content-center gap-4 flex-wrap user-select-none">
            <span class="step-dot <?php if($currentStep >= 1): ?> step-dot-active <?php endif; ?>"></span>
            <span class="step-label <?php if($currentStep > 1): ?> text-muted <?php endif; ?>">اطلاعات پایه</span>
            <span class="step-line <?php if($currentStep >= 2): ?> step-line-past <?php endif; ?>"></span>
            <span class="step-dot <?php if($currentStep >= 2): ?> step-dot-active <?php endif; ?>"></span>
            <span class="step-label <?php if($currentStep != 2): ?> text-muted <?php endif; ?>">مشخصات نامه</span>
            <span class="step-line <?php if($currentStep >= 3): ?> step-line-past <?php endif; ?>"></span>
            <span class="step-dot <?php if($currentStep >= 3): ?> step-dot-active <?php endif; ?>"></span>
            <span class="step-label <?php if($currentStep != 3): ?> text-muted <?php endif; ?>">متن نامه</span>
            <span class="step-line <?php if($currentStep >= 4): ?> step-line-past <?php endif; ?>"></span>
            <span class="step-dot <?php if($currentStep >= 4): ?> step-dot-active <?php endif; ?>"></span>
            <span class="step-label <?php if($currentStep != 4): ?> text-muted <?php endif; ?>">پیوست و ارسال</span>
        </div>

        <!-- گام ۱: اطلاعات پایه (فرستنده، گیرنده، پروژه، قالب) -->
        <?php if($currentStep == 1): ?>
            <div class="form-step-container">
                <h4 class="mb-4 text-primary fw-bold"><i class="ti ti-info-circle me-2"></i> اطلاعات مبدأ و مقصد</h4>
                <div class="row gx-5 gy-4">
                    <!-- فرستنده -->
                    <div class="col-md-6 mb-3">
                        <label for="from_who" class="form-label fw-bold">
                            <i class="ti ti-user me-2 text-primary"></i>فرستنده <span class="text-danger">*</span>
                        </label>
                        <input type="text" class="form-control form-control-lg" id="from_who" wire:model.defer="from_who" placeholder="نام یا واحد فرستنده">
                        <?php $__errorArgs = ['from_who'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- گیرنده -->
                    <div class="col-md-6 mb-3">
                        <label for="from_where" class="form-label fw-bold">
                            <i class="ti ti-map-pin me-2 text-primary"></i>گیرنده <span class="text-danger">*</span>
                        </label>
                        <input type="text" class="form-control form-control-lg" id="from_where" wire:model.defer="from_where" placeholder="نام یا واحد گیرنده">
                        <?php $__errorArgs = ['from_where'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- پروژه -->
                    <div class="col-md-6 mb-3">
                        <label for="project_id" class="form-label fw-bold">
                            <i class="ti ti-building-project me-2 text-primary"></i>پروژه مرتبط <span class="text-danger">*</span>
                        </label>
                        <select id="project_id" class="form-select form-control-lg" wire:model.defer="project_id" <?php if($project_id && request()->route('projectId')): ?> disabled <?php endif; ?>>
                            <option value="">انتخاب پروژه</option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($project->id); ?>"><?php echo e($project->code); ?> - <?php echo e($project->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($project_id && request()->route('projectId')): ?>
                            <small class="text-muted d-block mt-1">پروژه به صورت خودکار از URL انتخاب شده است.</small>
                        <?php endif; ?>
                        <?php $__errorArgs = ['project_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- قالب نامه (اختیاری) - منتقل شده به گام ۱ -->
                    <div class="col-md-6 mb-3">
                        <label for="letterFormId" class="form-label fw-bold">
                            <i class="ti ti-layout-collage me-2 text-primary"></i>قالب نامه (اختیاری)
                        </label>
                        <select id="letterFormId" class="form-select form-control-lg" wire:model.live="letterFormId" <?php if($letterFormId && request()->route('templateId')): ?> disabled <?php endif; ?>>
                            <option value="">استفاده از قالب پیش‌فرض</option>
                            <?php $__currentLoopData = \App\Models\LetterForm::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($form->id); ?>"><?php echo e($form->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['letterFormId'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <?php if($letterFormId && request()->route('templateId')): ?>
                            <small class="text-muted d-block mt-1">قالب به صورت خودکار از URL انتخاب شده است.</small>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- پیش نمایش قالب (جدید) -->
                <?php if($selectedForm && $selectedForm->background): ?>
                    <div class="col-12 mt-4 text-center p-4 bg-white rounded-3 shadow-sm border border-info">
                        <label class="form-label fw-bold mb-3 text-info">
                            <i class="ti ti-photo me-2"></i> پیش‌نمایش پس‌زمینه قالب
                        </label>
                        <img src="<?php echo e($selectedForm->background); ?>" class="img-fluid rounded-lg shadow-md" style="max-height: 250px; border: 1px solid #ddd;" alt="پیش‌نمایش قالب">
                    </div>
                <?php endif; ?>
            </div>

            <!-- دکمه‌های ناوبری گام ۱ -->
            <div class="mt-5 text-end">
                <button type="button" wire:click="nextStep" class="btn btn-primary btn-lg rounded-pill px-5 shadow-lg">
                    گام بعدی <i class="ti ti-arrow-left ms-2"></i>
                </button>
            </div>
        <?php endif; ?>

        <!-- گام ۲: مشخصات نامه (عنوان، طبقه بندی، اولویت، امضاکننده و سمت) -->
        <?php if($currentStep == 2): ?>
            <div class="form-step-container">
                <h4 class="mb-4 text-primary fw-bold"><i class="ti ti-list-details me-2"></i> جزئیات و طبقه‌بندی</h4>
                <div class="row gx-5 gy-4">
                    <!-- عنوان -->
                    <div class="col-12 mb-3">
                        <label for="title" class="form-label fw-bold">
                            <i class="ti ti-heading me-2 text-primary"></i>عنوان نامه <span class="text-danger">*</span>
                        </label>
                        <input type="text" class="form-control form-title-wide form-control-lg" id="title" wire:model.defer="title" placeholder="موضوع نامه">
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- طبقه‌بندی -->
                    <div class="col-md-6 mb-3">
                        <label for="classification_id" class="form-label fw-bold">
                            <i class="ti ti-layers me-2 text-primary"></i>طبقه‌بندی <span class="text-danger">*</span>
                        </label>
                        <select id="classification_id" class="form-select form-control-lg" wire:model.defer="classification_id">
                            <option value="">انتخاب طبقه‌بندی</option>
                            <?php $__currentLoopData = $classifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($classification->id); ?>"><?php echo e($classification->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['classification_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- اولویت نامه -->
                    <div class="col-md-6 mb-3">
                        <label class="form-label fw-bold">
                            <i class="ti ti-alert me-2 text-primary"></i>اولویت نامه <span class="text-danger">*</span>
                        </label>
                        <select class="form-select form-control-lg" wire:model.defer="type">
                            <option value="">انتخاب اولویت</option>
                            <option value="<?php echo e(\App\Models\Letter::PRIORITY_NORMAL); ?>">عادی (Normal)</option>
                            <option value="<?php echo e(\App\Models\Letter::PRIORITY_URGENT); ?>">فوری (Urgent)</option>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- امضاکننده (جدید) -->
                    <div class="col-md-6 mb-3">
                        <label for="signer_user_id" class="form-label fw-bold">
                            <i class="ti ti-signature me-2 text-primary"></i>امضاکننده <span class="text-danger">*</span>
                        </label>
                        <!-- wire:model.live برای بروزرسانی signerPositions در بک‌اند -->
                        <select id="signer_user_id" class="form-select form-control-lg" wire:model.live="signer_user_id">
                            <option value="">انتخاب امضاکننده</option>
                            <?php $__currentLoopData = $allUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['signer_user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- سمت امضاکننده (جدید) -->
                    <div class="col-md-6 mb-3">
                        <label for="signature_position" class="form-label fw-bold">
                            <i class="ti ti-id-badge me-2 text-primary"></i>سمت امضاکننده <span class="text-danger">*</span>
                        </label>
                        <!-- دراپ‌داون سمت فعال شد و با لیست سمت‌های امضاکننده پر می‌شود -->
                        <select id="signature_position" class="form-select form-control-lg" wire:model.defer="signature_position">
                            <?php if(empty($signerPositions)): ?>
                                <option value="" disabled>امضاکننده را انتخاب کنید</option>
                            <?php else: ?>
                                <option value="">انتخاب سمت</option>
                                <?php $__currentLoopData = $signerPositions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($position); ?>"><?php echo e($position); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                        <?php if(count($signerPositions) > 0): ?>
                            <small class="text-muted d-block mt-1">سمت‌های موجود برای امضاکننده انتخاب شده.</small>
                        <?php endif; ?>
                        <?php $__errorArgs = ['signature_position'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- دکمه‌های ناوبری گام ۲ -->
            <div class="mt-5 d-flex justify-content-between">
                <button type="button" wire:click="prevStep" class="btn btn-outline-warning btn-lg rounded-pill px-5 shadow-sm">
                    <i class="ti ti-arrow-right me-2"></i> گام قبلی
                </button>
                <button type="button" wire:click="nextStep" class="btn btn-primary btn-lg rounded-pill px-5 shadow-lg">
                    گام بعدی <i class="ti ti-arrow-left ms-2"></i>
                </button>
            </div>
        <?php endif; ?>

        <!-- گام ۳: متن نامه (TinyMCE) -->
        <?php if($currentStep == 3): ?>
            <div
                x-init="
                    tinymce.get('editorLetter') && tinymce.get('editorLetter').remove();
                    initializeTinyMCE();
                "
                class="form-step-container"
            >
                <h4 class="mb-4 text-primary fw-bold"><i class="ti ti-file-text me-2"></i> محتوای نامه</h4>
                <!-- متن نامه -->
                <div class="col-12 mb-3" wire:ignore>
                    <label for="editorLetter" class="form-label fw-bold">
                        <i class="ti ti-edit me-2 text-primary"></i>متن نامه <span class="text-danger">*</span>
                    </label>
                    <!-- TinyMCE Editor -->
                    <textarea id="editorLetter" class="form-control rich-textarea" wire:model="content" rows="15" placeholder="متن نامه..."></textarea>
                    <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- پیش نمایش قالب (اختیاری) -->
                <?php if($selectedForm): ?>
                    <div class="col-12 mt-3 p-3 bg-white rounded-3 shadow border border-info">
                        <h6 class="text-info fw-bold"><i class="ti ti-info-circle me-1"></i> پیش‌نمایش قالب انتخاب شده: <?php echo e($selectedForm->name); ?></h6>
                        <div class="border p-2 bg-light rounded-3" style="max-height: 250px; overflow-y: auto;">
                            <?php echo $selectedForm->background; ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- دکمه‌های ناوبری گام ۳ -->
            <div class="mt-5 d-flex justify-content-between">
                <button type="button" wire:click="prevStep" class="btn btn-outline-warning btn-lg rounded-pill px-5 shadow-sm">
                    <i class="ti ti-arrow-right me-2"></i> گام قبلی
                </button>
                <button type="button" wire:click="nextStep" class="btn btn-primary btn-lg rounded-pill px-5 shadow-lg">
                    گام بعدی <i class="ti ti-arrow-left ms-2"></i>
                </button>
            </div>
        <?php endif; ?>

        <!-- گام ۴: پیوست و ارسال (رونوشت و پیوست‌ها) -->
        <?php if($currentStep == 4): ?>
            <div class="form-step-container">
                <h4 class="mb-4 text-primary fw-bold"><i class="ti ti-send me-2"></i> تنظیمات نهایی و ارسال</h4>

                <!-- رونوشت (Cc) -->
                <div class="col-12 mb-4 p-4 border rounded-3 bg-white shadow-sm">
                    <label class="form-label fw-bold mb-3">
                        <i class="ti ti-users me-2 text-primary"></i>رونوشت (Cc)
                    </label>
                    <div class="input-group mb-3 rounded-pill overflow-hidden border border-primary-subtle">
                        <input type="text" class="form-control border-0 py-3" placeholder="نام رونوشت" wire:model.live="cc_name">
                        <input type="text" class="form-control border-end-0 border-top-0 border-bottom-0 py-3" placeholder="سمت (اختیاری)" wire:model.live="cc_position">
                        <button class="btn btn-primary px-4" type="button" wire:click="addCc">
                            <i class="ti ti-plus me-1"></i> افزودن
                        </button>
                    </div>
                    <?php $__errorArgs = ['cc_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    <div class="mt-3">
                        <?php $__currentLoopData = $ccs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="badge rounded-pill bg-info text-white px-3 py-2 me-2 mb-1 shadow-sm">
                                <?php echo e($cc['name']); ?> <?php if($cc['position']): ?> - <?php echo e($cc['position']); ?> <?php endif; ?>
                                <button type="button" class="btn btn-link text-white shadow-0 p-0 ms-2 opacity-75 hover:opacity-100" wire:click="removeCc(<?php echo e($i); ?>)" style="font-size:1.05em; line-height: 1;">
                                    <i class="ti ti-x"></i>
                                </button>
                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- پیوست‌ها (Modern Drag-and-Drop) -->
                <div class="col-12 mb-4 p-4 border rounded-3 bg-white shadow-sm">
                    <label class="form-label fw-bold mb-3">
                        <i class="ti ti-paperclip me-2 text-primary"></i>پیوست‌ها
                    </label>
                    <div x-data="{ dragging: false }"
                         @dragover.prevent="dragging = true"
                         @dragleave.prevent="dragging = false"
                         @drop.prevent="dragging = false; $refs.fileInput.files = event.dataTransfer.files; $wire.set('attachments', $refs.fileInput.files);"
                         :class="{ 'border-primary border-4 bg-primary-subtle': dragging, 'border-2': !dragging }"
                         class="drag-uploader text-center p-5 bg-light rounded-3 shadow-md border-dashed border-gray-300 transition-all duration-200">
                        <i class="ti ti-upload mb-2 d-block mx-auto" style="font-size:3em; color:#409fff"></i>
                        <p class="mb-1 text-secondary">فایل‌ها را اینجا بکشید و رها کنید</p>
                        <span class="small text-muted mb-3 d-block">یا</span>
                        <input type="file" x-ref="fileInput" wire:model="attachments" class="d-none" multiple>
                        <button type="button" class="btn btn-outline-primary rounded-pill px-4 mt-2" @click="$refs.fileInput.click()">
                            انتخاب فایل از کامپیوتر
                        </button>

                        <?php if(count($attachments)): ?>
                            <ul class="list-unstyled mt-4 text-start small border-top pt-3">
                                <?php $__currentLoopData = $attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="d-flex align-items-center justify-content-between mb-2 px-3 py-2 border rounded-3 bg-white shadow-xs">
                                        <span class="text-truncate">
                                            <i class="ti ti-file me-2 text-info"></i><?php echo e($file->getClientOriginalName()); ?>

                                            <span class="text-muted ms-1">(<?php echo e(number_format($file->getSize()/1024,1)); ?> KB)</span>
                                        </span>
                                        <button type="button" class="btn btn-sm btn-link text-danger p-0 ms-3" wire:click="removeAttachment(<?php echo e($index); ?>)">
                                            <i class="ti ti-x"></i>
                                        </button>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                        <?php $__errorArgs = ['attachments.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="f-error"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <!-- جمع‌بندی (Summary) -->
                <div class="col-12 mt-4 p-4 border rounded-3 bg-light-subtle shadow-sm">
                    <div class="card p-4 bg-white border-0 shadow-sm">
                        <h5 class="card-title fw-bold text-primary border-bottom pb-2 mb-3"><i class="ti ti-clipboard-list me-1"></i> خلاصه نهایی نامه</h5>
                        <ul class="list-group list-group-flush small">
                            <?php $__currentLoopData = $summary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($key !== 'ccs' && $key !== 'attachments_count' && $key !== 'signer' && $key !== 'signature_position'): ?>
                                    <li class="list-group-item bg-white d-flex justify-content-between py-2">
                                        <span class="text-muted"><?php echo e(str_replace(['project', 'title', 'from_who', 'from_where', 'classification', 'type'], ['پروژه', 'عنوان', 'فرستنده', 'گیرنده', 'طبقه‌بندی', 'اولویت'], $key)); ?>:</span>
                                        <span class="fw-medium text-dark"><?php echo e($value ?: 'وارد نشده'); ?></span>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item bg-white d-flex justify-content-between py-2">
                                <span class="text-muted">امضاکننده:</span>
                                <span class="fw-medium text-dark"><?php echo e($summary['signer'] ?: 'وارد نشده'); ?></span>
                            </li>
                            <li class="list-group-item bg-white d-flex justify-content-between py-2">
                                <span class="text-muted">سمت امضاکننده:</span>
                                <span class="fw-medium text-dark"><?php echo e($summary['signature_position'] ?: 'وارد نشده'); ?></span>
                            </li>
                            <li class="list-group-item bg-white d-flex justify-content-between py-2">
                                <span class="text-muted">پیوست‌ها:</span>
                                <span class="fw-medium text-info"><?php echo e($summary['attachments_count']); ?> فایل</span>
                            </li>
                            <li class="list-group-item bg-white">
                                <span class="text-muted d-block mb-1">رونوشت‌ها:</span>
                                <?php if(empty($summary['ccs'])): ?>
                                    <span class="fw-medium text-muted">ندارد</span>
                                <?php else: ?>
                                    <?php $__currentLoopData = $summary['ccs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-info-subtle text-info fw-medium me-1"><?php echo e($cc['name']); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- دکمه‌های ناوبری گام ۴ (ثبت نهایی) -->
            <div class="mt-5 d-flex justify-content-between">
                <button type="button" wire:click="prevStep" class="btn btn-warning btn-lg rounded-pill px-5 shadow-lg shadow-warning-subtle">
                    <i class="ti ti-arrow-right me-2"></i> گام قبلی
                </button>
                <button type="submit" class="btn btn-success btn-lg rounded-pill px-5 shadow-lg shadow-success-subtle" wire:loading.attr="disabled">
                    <span wire:loading.remove><i class="ti ti-send me-1"></i> ثبت و ارسال نامه</span>
                    <span wire:loading><span class="spinner-border spinner-border-sm me-2"></span> در حال ذخیره...</span>
                </button>
            </div>
        <?php endif; ?>

    </form>

    <!-- CSS Styles -->
    <style>
        /* General Modernization */
        .form-control, .form-select {
            border-radius: 0.75rem;
            border: 1px solid #dee2e6;
            transition: all 0.2s;
        }
        .form-control:focus, .form-select:focus {
            border-color: #409fff;
            box-shadow: 0 0 0 0.25rem rgba(64, 159, 255, 0.25);
        }
        .btn-primary, .btn-success, .btn-warning {
            border-radius: 2rem !important;
        }
        .shadow-2xl { box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25); }
        .shadow-md { box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -2px rgba(0, 0, 0, 0.1); }
        .shadow-xs { box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05); }
        .border-dashed { border-style: dashed; }
        .form-step-container {
            padding: 2.5rem;
            border-radius: 1rem;
            background: #f8f9fa;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        /* Stepper Styles */
        .step-label { font-weight: 700; font-size: 1.15em; color: #2d3b71; }
        .step-dot { width: 20px; height: 20px; border-radius: 50%; background: #e3ecfb; display: inline-block; }
        .step-dot-active {
            background: #409fff;
            box-shadow: 0 0 0 5px #b1d4fb;
            transition: all 0.3s ease;
        }
        .step-line { width: 60px; height: 4.7px; background: #e3ecfb; display: inline-block; border-radius: 2px; }
        .step-line-past { background: #409fff !important; }

        .f-error {
            color: #dc3545;
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        /* TinyMCE Customization */
        .tox-tinymce {
            border-radius: 0.75rem !important;
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.1);
        }
        .tox-edit-area__iframe {
            font-family: IRANSansWeb, Vazir, Tahoma, Arial, sans-serif !important;
            direction: rtl !important;
            text-align: right !important;
        }
    </style>

    <?php $__env->startPush('scripts'); ?>
        <script src="<?php echo e(url('panel/plugin/tinymce/tinymce.min.js')); ?>"></script>

        <script>
            // تابع جهانی برای راه‌اندازی TinyMCE
            function initializeTinyMCE() {
                // Placeholder logic
                const editorId = 'editorLetter';
                const container = document.querySelector('[wire\\:ignore] textarea#' + editorId).parentNode;

                container.querySelectorAll('.editor-placeholder').forEach(el => el.remove());

                const placeholder = document.createElement('div');
                placeholder.className = 'editor-placeholder';
                placeholder.textContent = 'متن نامه را اینجا بنویسید...';

                // Placeholder CSS for better visibility
                placeholder.style.cssText = `
                    position: absolute;
                    top: 50%;
                    transform: translateY(-50%);
                    right: 20px;
                    color: #9ca3af;
                    padding: 1.2rem;
                    pointer-events: none;
                    font-family: IRANSansWeb, Vazir, Tahoma, Arial, sans-serif;
                    font-size: 16px;
                    direction: rtl;
                    text-align: right;
                `;

                container.appendChild(placeholder);

                // --- پلاگین‌ها و تنظیمات دلخواه شما ---
                tinymce.init({
                    selector: '#' + editorId,
                    license_key: 'gpl',
                    language: 'fa',
                    directionality: 'rtl',
                    height: 500,

                    // FIX: حذف پلاگین‌های ناموجود
                    menubar: 'file edit view insert format tools table help',
                    plugins: 'preview importcss searchreplace autolink directionality visualblocks visualchars fullscreen image link media codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons table',

                    // FIX: استفاده از styleselect/blocks به جای fontselect/fontsize
                    toolbar: 'undo redo | bold italic underline strikethrough | styleselect blocks | alignleft aligncenter alignright alignjustify | outdent indent | numlist bullist | forecolor backcolor removeformat | link image table | fullscreen preview',

                    toolbar_mode: 'sliding',
                    quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',

                    // فونت‌ها
                    fontsize_formats: '8pt 10pt 12pt 14pt 16pt 18pt 20pt 24pt 36pt',
                    font_formats:
                        'IRANSansWeb=IRANSansWeb, sans-serif;' +
                        'Vazir=Vazir, Tahoma, sans-serif;' +
                        'PeydaWebNoEn=PeydaWebNoEn, sans-serif;' +
                        'IranNastaliq=IranNastaliq, serif;' +
                        'dana=dana, sans-serif;' +
                        'Tahoma=Tahoma, Geneva, sans-serif;' +
                        'Arial=Arial, Helvetica, sans-serif;' +
                        'Times New Roman=Times New Roman,Times,serif;',

                    // FIX: استایل محتوا برای رندر صحیح فونت‌های فارسی
                    content_style: `
                        body {
                            font-family: IRANSansWeb, Vazir, PeydaWebNoEn, Tahoma, Arial, sans-serif;
                            font-size: 16px;
                            direction: rtl;
                            text-align: right;
                            line-height: 1.8;
                            color: #1f2937;
                            padding: 1.2rem;
                        }
                    `,
                    branding: false,
                    promotion: false,

                    // FIX: تصاویر آپلود
                    images_upload_handler: function (blobInfo, success, failure) {
                        const formData = new FormData();
                        formData.append('image', blobInfo.blob());
                        formData.append('_token', '<?php echo e(csrf_token()); ?>');

                        return fetch('<?php echo e(route("upload.tinymce.image")); ?>', {
                            method: 'POST',
                            body: formData,
                            headers: {
                                'X-Requested-With': 'XMLHttpRequest'
                            }
                        })
                            .then(response => {
                                if (!response.ok) {
                                    throw new Error(`HTTP error! status: ${response.status}`);
                                }
                                return response.json();
                            })
                            .then(data => {
                                if (data.location) {
                                    success(data.location);
                                } else {
                                    failure(data.error?.message || data.message || 'آپلود تصویر با خطا مواجه شد.');
                                }
                            })
                            .catch(error => {
                                failure('خطا در ارتباط با سرور یا آپلود: ' + error.message);
                            });
                    },

                    setup: function (editor) {
                        editor.on('init', () => {
                            const content = editor.getContent({ format: 'text' }).trim();
                            placeholder.style.display = content ? 'none' : 'block';

                            if (window.Livewire.find('<?php echo e($_instance->getId()); ?>').content) {
                                editor.setContent(window.Livewire.find('<?php echo e($_instance->getId()); ?>').content);
                            }
                        });

                        editor.on('change keyup', () => {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('content', editor.getContent());

                            const content = editor.getContent({ format: 'text' }).trim();
                            placeholder.style.display = content ? 'none' : 'block';
                        });

                        editor.on('blur', () => {
                            window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('content', editor.getContent());
                        });

                        Livewire.hook('element.updated', (el, component) => {
                            if (el.id === editorId && component.get('currentStep') == 3) {
                                const newContent = component.get('content');
                                if (newContent !== editor.getContent()) {
                                    editor.setContent(newContent || '');
                                }
                                const content = editor.getContent({ format: 'text' }).trim();
                                placeholder.style.display = content ? 'none' : 'block';
                            }
                        });
                    }
                });
            }

            // AlpineJS init logic: runs when step 3 is loaded
            document.addEventListener('alpine:init', () => {
                Livewire.on('scroll-to-top', () => {
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                });
            });

            // پاک کردن محتوای ادیتور پس از ذخیره موفق
            window.addEventListener('clearEditor', event => {
                if (tinymce.get('editorLetter')) {
                    tinymce.get('editorLetter').setContent('');
                    const placeholder = document.querySelector('.editor-placeholder');
                    if(placeholder) placeholder.style.display = 'block';
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').set('content', '');
                }
            });

            // اجرای مجدد TinyMCE پس از ناوبری Livewire (برای اطمینان در محیط‌های SPA)
            document.addEventListener('livewire:navigated', () => {
                if (tinymce.get('editorLetter')) {
                    tinymce.get('editorLetter').remove();
                }
            });
        </script>
    <?php $__env->stopPush(); ?>

</div><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\letter\create-letter.blade.php ENDPATH**/ ?>