<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>درخواست هزینه‌های جزء #<?php echo e($request->id); ?></title>

    <style>
        @font-face {
            font-family: 'Vazir';
            src: url('/fonts/vazir.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }

        body {
            font-family: 'Vazir', 'Segoe UI', Tahoma, sans-serif;
            direction: rtl;
            font-size: 9pt;
            line-height: 1.5;
            color: #334155;
            margin: 0;
            padding: 15px 20px; /* کاهش padding */
            background-color: #ffffff;
            -webkit-print-color-adjust: exact;
        }

        /* ------------------ تنظیمات هدر (فشرده‌تر و منظم‌تر) ------------------ */
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            gap: 16px;
            margin-bottom: 20px; /* کاهش فاصله */
            padding-bottom: 10px;
            border-bottom: 2px solid #1e40af; /* خط پررنگ تر */
        }
        .logo-container {
            width: 50px;
            height: 50px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            background: #f8fafc;
            padding: 5px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        .logo {
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }
        .title-section {
            text-align: center;
            flex-grow: 1;
            padding: 0 10px;
        }
        .main-title {
            font-size: 16pt; /* کمی کوچکتر */
            font-weight: 900;
            color: #1e293b;
            margin: 0;
            letter-spacing: -0.5px;
            position: relative;
            padding-bottom: 5px;
        }
        .main-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 70px;
            height: 1px; /* نازک‌تر */
            background: #1e40af;
            border-radius: 1px;
        }

        .doc-info {
            flex-shrink: 0;
            text-align: left;
            font-size: 8.5pt;
            color: #475569;
            display: flex;
            flex-direction: column;
            gap: 4px;
        }
        .doc-item {
            display: flex;
            align-items: center;
            gap: 6px;
        }
        .doc-icon {
            color: #1e40af; /* رنگ آبی سازمانی */
            font-weight: bold;
            font-size: 8pt;
        }
        .doc-id-box {
            background: #1e40af;
            color: white;
            padding: 2px 8px;
            border-radius: 15px;
            font-weight: 800;
            font-size: 8pt;
            display: inline-flex;
            align-items: center;
        }
        /* ------------------ پایان تنظیمات هدر ------------------ */

        /* ——— بخش‌ها ——— */
        .section {
            margin-bottom: 18px;
        }
        .section-title {
            font-size: 10pt;
            font-weight: 800;
            color: #1e40af;
            margin-bottom: 8px;
            padding-bottom: 4px;
            border-bottom: 1px solid #e2e8f0;
            position: relative;
            display: inline-block;
        }
        .section-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            right: 0;
            width: 24px;
            height: 2px;
            background: #1e40af;
        }

        .info-grid {
            width: 100%;
            border-collapse: collapse;
            font-size: 8.5pt;
        }
        .info-grid td {
            padding: 4px 0;
            vertical-align: top;
            width: 33.33%;
        }
        .info-grid strong {
            color: #334155;
            font-weight: 700;
            display: inline-block;
            width: 80px;
        }

        .status-badge {
            font-weight: 700;
            padding: 3px 10px;
            border-radius: 15px;
            font-size: 8pt;
            color: white;
            display: inline-block;
        }
        .status-pending { background-color: #f59e0b; }
        .status-approved { background-color: #10b981; }
        .status-rejected { background-color: #ef4444; }
        .status-paid { background-color: #3b82f6; }

        .amount {
            color: #ef4444;
            font-weight: 800;
            font-size: 10pt;
        }

        .reason-box {
            background-color: #f9fafb;
            padding: 12px 16px; /* کاهش padding */
            border-radius: 6px;
            border-right: 4px solid #3b82f6;
            font-size: 9pt;
            margin: 0;
            line-height: 1.6;
        }

        /* ——— جدول‌ها ——— */
        .data-table, .approval-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 6px; /* کاهش فاصله */
            font-size: 8.5pt;
            border: 1px solid #e2e8f0;
            border-radius: 6px;
            overflow: hidden;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }

        .data-table th {
            background-color: #1e40af;
            color: white;
            font-weight: 700;
            text-align: center;
        }

        .approval-table th {
            background-color: #f1f5f9;
            color: #1e293b;
            font-weight: 700;
        }
        .data-table th, .data-table td,
        .approval-table th, .approval-table td {
            padding: 6px 10px; /* کاهش padding */
            text-align: right;
            border: 1px solid #edf2f7;
        }

        .total-row td {
            background-color: #ebf8ff;
            font-weight: 800;
            color: #1e3a8a;
            border-top: 2px solid #bfdbfe;
        }
        .comment-row td {
            background-color: #f0f9ff;
            font-size: 8pt;
            padding: 5px 12px;
            border-left: 3px solid #60a5fa;
        }

        /* ——— امضا ——— */
        .signature-section {
            margin-top: 20px; /* کاهش فاصله */
            padding-top: 12px;
            border-top: 1px dashed #cbd5e1;
        }

        .signature-table {
            width: 100%;
            table-layout: fixed;
            border-collapse: collapse;
        }

        .signature-col {
            padding: 0 8px; /* کاهش padding */
            text-align: center;
            vertical-align: top;
        }

        .signature-role {
            font-weight: 800;
            font-size: 9pt;
            color: #1e40af;
            margin-bottom: 4px;
        }

        .digital-signature {
            width: 100%;
            height: 45px; /* کاهش ارتفاع */
            border: 1px dashed #cbd5e1;
            border-radius: 4px;
            background: #f8fafc;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 6px 0;
            font-size: 8pt;
            color: #64748b;
        }
        .digital-signature img {
            max-width: 80%;
            max-height: 35px; /* کاهش ارتفاع */
            object-fit: contain;
        }

        /* ——— پاورقی ——— */
        .footer {
            margin-top: 18px;
            padding: 8px; /* کاهش padding */
            background-color: #f8fafc;
            border-radius: 4px;
            border: 1px solid #e2e8f0;
            font-size: 8pt;
            color: #64748b;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }
        .footer-logo {
            width: 25px;
            height: 25px;
        }

        .project-tag {
            display: inline-block;
            background: #dbeafe;
            color: #1d4ed8;
            padding: 2px 8px;
            border-radius: 20px;
            font-size: 7.5pt;
            margin-left: 4px;
            border: 1px solid #bfdbfe;
        }
    </style>
</head>
<body>

<?php
    // فرض می‌کنیم تابع toJalali() از Route به اینجا ارسال شده است و کار می‌کند.
    // ⚠️ اگر از پکیج استفاده نمی‌کنید، باید منطق این تابع را در Route به درستی پیاده کنید.

    $createdAtJalali = toJalali($request->created_at);
    $currentDateJalali = toJalali(now(), 'Y/m/d');

    // امضاهای فرضی برای مثال
    $requesterSignature = public_path('app/images/signatures/' . $request->user->signature_image);
?>

<div class="header">
    <div class="logo-container">
        <?php
            $company = $request->user->company;
            $logoFileName = $company->image ?? null;
            $logoPath = null;

            if ($logoFileName) {
                $logoPath = public_path('app/images/company/logo/' . $logoFileName);
                if (!file_exists($logoPath)) {
                    $logoPath = null;
                }
            }
        ?>

        <?php if($logoPath): ?>
            <img src="<?php echo e($logoPath); ?>" class="logo" alt="لوگو">
        <?php else: ?>
            <div style="font-size: 7pt; font-weight: 800; color: #475569; line-height: 1.2; text-align: center;">
                <?php echo e(Str::limit($request->user->company->name ?? 'شرکت', 8, '')); ?>

            </div>
        <?php endif; ?>
    </div>

    <div class="title-section">
        <h1 class="main-title">درخواست تنخواه</h1>
    </div>

    <div class="doc-info">
        <div class="doc-item">
            <span class="doc-icon">📅</span>
            <span>تاریخ صدور:</span>
            <strong><?php echo e($currentDateJalali); ?></strong>
        </div>
        <div class="doc-item">
            <span class="doc-icon">#️⃣</span>
            <span>شماره سند:</span>
            <span class="doc-id-box">#<?php echo e($request->id); ?></span>
        </div>
    </div>
</div>

<div class="section">
    <div class="section-title">📋 اطلاعات کلی درخواست</div>
    <table class="info-grid">
        <tr>
            <td><strong>👤 درخواست‌دهنده:</strong> <?php echo e($request->user->name); ?></td>
            <td><strong>🏢 شرکت/بخش:</strong> <?php echo e($request->user->company->name ?? 'نامشخص'); ?></td>
            <td><strong>📊 وضعیت:</strong>
                <span class="status-badge status-<?php echo e($request->status); ?>"><?php echo e($request->statusLabel()); ?></span>
            </td>
        </tr>
        <tr>
            <td><strong>💰 مبلغ کل:</strong> <span class="amount"><?php echo e(number_format($request->amount)); ?> ریال</span></td>
            <td><strong>🕒 تاریخ ثبت:</strong> **<?php echo e($createdAtJalali); ?>** | <?php echo e($request->created_at->format('H:i')); ?></td>
            <td><strong>📁 پروژه‌ها:</strong>
                <?php if($request->projects->isNotEmpty()): ?>
                    <?php $__currentLoopData = $request->projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="project-tag"><?php echo e($project->name); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <span style="color:#94a3b8;">—</span>
                <?php endif; ?>
            </td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">📝 شرح و دلیل درخواست</div>
    <div class="reason-box">
        <?php echo e($request->reason ?: 'شرحی برای درخواست ارائه نشده است.'); ?>

    </div>
</div>

<?php if($request->details_json): ?>
    <div class="section">
        <div class="section-title">🧾 ریز اقلام هزینه‌ها</div>
        <table class="data-table">
            <thead>
            <tr>
                <th style="width: 50%;">شرح هزینه</th>
                <th style="width: 10%;">تعداد</th>
                <th style="width: 20%;">قیمت واحد (ریال)</th>
                <th style="width: 20%;">جمع (ریال)</th>
            </tr>
            </thead>
            <tbody>
            <?php $total = 0; ?>
            <?php $__currentLoopData = $request->details_json; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $itemTotal = ($item['qty'] ?? 0) * ($item['price'] ?? 0); $total += $itemTotal; ?>
                <tr>
                    <td><?php echo e($item['item'] ?? '—'); ?></td>
                    <td style="text-align: center;"><?php echo e($item['qty'] ?? 0); ?></td>
                    <td dir="ltr" style="text-align: right;"><?php echo e(number_format($item['price'] ?? 0)); ?></td>
                    <td style="color: #1e293b; font-weight: 600;" dir="ltr"><?php echo e(number_format($itemTotal)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
            <tr class="total-row">
                <td colspan="3" style="text-align: left;">💰 جمع کل مبلغ درخواستی:</td>
                <td dir="ltr" style="text-align: right; font-size: 10.5pt;"><?php echo e(number_format($request->amount)); ?> ریال</td>
            </tr>
            </tfoot>
        </table>
    </div>
<?php endif; ?>

<div class="section">
    <div class="section-title">🔄 سیر تأیید درخواست</div>
    <table class="approval-table">
        <thead>
        <tr>
            <th style="width: 35%;">تأییدکننده</th>
            <th style="width: 15%;">وضعیت</th>
            <th style="width: 50%;">تاریخ اقدام / توضیحات</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $request->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <?php echo e($approval->approver->name); ?><br>
                    <small style="color:#64748b; font-size: 7.5pt;">
                        (<?php echo e($approval->approver->position ?? 'سمت نامشخص'); ?>)
                    </small>
                </td>
                <td style="text-align: center;">
                        <span style="font-weight: 700; color: <?php echo e($approval->statusColor() === 'success' ? '#16a34a' : ($approval->statusColor() === 'danger' ? '#dc2626' : '#f59e0b')); ?>;">
                            <?php echo e($approval->statusLabel()); ?>

                        </span>
                </td>
                <td style="text-align: left;">
                    <?php if($approval->approved_at): ?>
                        <?php $approvedAtJalali = toJalali($approval->approved_at); ?>
                        <span style="color:#475569;">📅 **<?php echo e($approvedAtJalali); ?>** | <?php echo e($approval->approved_at->format('H:i')); ?></span>
                    <?php else: ?>
                        <span style="color:#94a3b8;">در انتظار</span>
                    <?php endif; ?>
                </td>
            </tr>
            <?php if($approval->comments): ?>
                <tr class="comment-row">
                    <td colspan="3">
                        <span style="font-weight: 700; color: #1d4ed8;">💬 توضیحات:</span>
                        <?php echo e($approval->comments); ?>

                    </td>
                </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<div class="section signature-section">
    <div class="section-title">✍️ تأییدیه‌های نهایی</div>
    <table class="signature-table">
        <tr>
            <td class="signature-col">
                <div class="signature-role">درخواست‌دهنده</div>
                <div class="signature-info"><?php echo e($request->user->name); ?></div>
                <div class="digital-signature">
                    <?php if(file_exists($requesterSignature)): ?>
                        <img src="<?php echo e($requesterSignature); ?>" alt="امضای دیجیتال درخواست‌دهنده">
                    <?php else: ?>
                        <span>امضای دیجیتال</span>
                    <?php endif; ?>
                </div>
                <div class="signature-info">تاریخ ثبت: **<?php echo e($createdAtJalali); ?>**</div>
            </td>

            <td class="signature-col">
                <div class="signature-role">مدیر/مسئول</div>
                <div class="signature-info">امضا و مهر</div>
                <div class="digital-signature">
                    <?php
                        $finalApprover = $request->approvals->where('status', 'success')->last();
                    ?>
                    <?php if($finalApprover && $finalApprover->approver->signature_image && file_exists(public_path('app/images/signatures/' . $finalApprover->approver->signature_image))): ?>
                        <img src="<?php echo e(public_path('app/images/signatures/' . $finalApprover->approver->signature_image)); ?>" alt="امضای مدیر">
                    <?php else: ?>
                        <span>امضای مدیر/مسئول</span>
                    <?php endif; ?>
                </div>
                <div class="signature-info">تاریخ تصویب: **<?php echo e($finalApprover ? toJalali($finalApprover->approved_at) : '—'); ?>**</div>
            </td>

            <td class="signature-col">
                <div class="signature-role">امور مالی</div>
                <div class="signature-info">ثبت پرداخت</div>
                <div class="digital-signature">
                    <span>امضای امور مالی</span>
                </div>
                <div class="signature-info">تاریخ واریز: —</div>
            </td>
        </tr>
    </table>
</div>

<div class="footer">
    <div class="footer-logo">
        <?php
            $footerLogo = $request->user->company->footer_logo ?? null;
            $footerLogoPath = null;

            if ($footerLogo) {
                $footerLogoPath = public_path('app/images/company/footer/' . $footerLogo);
                if (!file_exists($footerLogoPath)) {
                    $footerLogoPath = null;
                }
            }
        ?>

        <?php if($footerLogoPath): ?>
            <img src="<?php echo e($footerLogoPath); ?>" alt="آرم سازمانی">
        <?php else: ?>
            <span style="font-size: 8pt; color: #475569; font-weight: 700;">A</span>
        <?php endif; ?>
    </div>
    <div class="footer-text">
        © <?php echo e(now()->year); ?> <?php echo e($request->user->company->name ?? 'شرکت'); ?> — این سند در تاریخ **<?php echo e($currentDateJalali); ?>** از سامانه داخلی تولید شده است.
    </div>
</div>

</body>
</html><?php /**PATH E:\prj\Mersa\32\45Mersa\Mersa\resources\views\livewire\admin\petty-cash\pdf.blade.php ENDPATH**/ ?>