<?php //86e1555b1c87e541bd6633d7c8c330c1
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Attachment_C;
    use LaravelIdea\Helper\App\Models\_IH_Attachment_QB;
    use LaravelIdea\Helper\App\Models\_IH_Blog_C;
    use LaravelIdea\Helper\App\Models\_IH_Blog_QB;
    use LaravelIdea\Helper\App\Models\_IH_Classification_C;
    use LaravelIdea\Helper\App\Models\_IH_Classification_QB;
    use LaravelIdea\Helper\App\Models\_IH_Company_C;
    use LaravelIdea\Helper\App\Models\_IH_Company_QB;
    use LaravelIdea\Helper\App\Models\_IH_ContractStatus_C;
    use LaravelIdea\Helper\App\Models\_IH_ContractStatus_QB;
    use LaravelIdea\Helper\App\Models\_IH_LetterView_C;
    use LaravelIdea\Helper\App\Models\_IH_LetterView_QB;
    use LaravelIdea\Helper\App\Models\_IH_Letter_C;
    use LaravelIdea\Helper\App\Models\_IH_Letter_QB;
    use LaravelIdea\Helper\App\Models\_IH_Permission_C;
    use LaravelIdea\Helper\App\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectDetail_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectDetail_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectFile_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectFile_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectFinancialDetail_C;
    use LaravelIdea\Helper\App\Models\_IH_projectFinancialDetail_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectFinancialDetail_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectInsurance_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectInsurance_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectProjectType_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectProjectType_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectSchedule_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectSchedule_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProjectType_C;
    use LaravelIdea\Helper\App\Models\_IH_ProjectType_QB;
    use LaravelIdea\Helper\App\Models\_IH_Project_C;
    use LaravelIdea\Helper\App\Models\_IH_Project_QB;
    use LaravelIdea\Helper\App\Models\_IH_Referral_C;
    use LaravelIdea\Helper\App\Models\_IH_Referral_QB;
    use LaravelIdea\Helper\App\Models\_IH_Role_C;
    use LaravelIdea\Helper\App\Models\_IH_Role_QB;
    use LaravelIdea\Helper\App\Models\_IH_Section_C;
    use LaravelIdea\Helper\App\Models\_IH_Section_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserPermission_C;
    use LaravelIdea\Helper\App\Models\_IH_UserPermission_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserPosition_C;
    use LaravelIdea\Helper\App\Models\_IH_UserPosition_QB;
    use LaravelIdea\Helper\App\Models\_IH_UserRole_C;
    use LaravelIdea\Helper\App\Models\_IH_UserRole_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_C;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;

    /**
     * @property int $id
     * @property int $letter_id
     * @property string $file_path
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Letter $letter
     * @method BelongsTo|_IH_Letter_QB letter()
     * @method static _IH_Attachment_QB onWriteConnection()
     * @method _IH_Attachment_QB newQuery()
     * @method static _IH_Attachment_QB on(null|string $connection = null)
     * @method static _IH_Attachment_QB query()
     * @method static _IH_Attachment_QB with(array|string $relations)
     * @method _IH_Attachment_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Attachment_C|Attachment[] all()
     * @ownLinks letter_id,\App\Models\Letter,id
     * @mixin _IH_Attachment_QB
     */
    class Attachment extends Model {}

    /**
     * @property int $id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Blog_QB onWriteConnection()
     * @method _IH_Blog_QB newQuery()
     * @method static _IH_Blog_QB on(null|string $connection = null)
     * @method static _IH_Blog_QB query()
     * @method static _IH_Blog_QB with(array|string $relations)
     * @method _IH_Blog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Blog_C|Blog[] all()
     * @mixin _IH_Blog_QB
     */
    class Blog extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Letter_C|Letter[] $letters
     * @property-read int $letters_count
     * @method HasMany|_IH_Letter_QB letters()
     * @method static _IH_Classification_QB onWriteConnection()
     * @method _IH_Classification_QB newQuery()
     * @method static _IH_Classification_QB on(null|string $connection = null)
     * @method static _IH_Classification_QB query()
     * @method static _IH_Classification_QB with(array|string $relations)
     * @method _IH_Classification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Classification_C|Classification[] all()
     * @foreignLinks id,\App\Models\Letter,classification_id
     * @mixin _IH_Classification_QB
     */
    class Classification extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $tel
     * @property string|null $fax
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ProjectDetail_C|ProjectDetail[] $projectsAsContractor
     * @property-read int $projects_as_contractor_count
     * @method HasMany|_IH_ProjectDetail_QB projectsAsContractor()
     * @property _IH_ProjectDetail_C|ProjectDetail[] $projectsAsMainClient
     * @property-read int $projects_as_main_client_count
     * @method HasMany|_IH_ProjectDetail_QB projectsAsMainClient()
     * @property _IH_ProjectDetail_C|ProjectDetail[] $projectsAsSubClient
     * @property-read int $projects_as_sub_client_count
     * @method HasMany|_IH_ProjectDetail_QB projectsAsSubClient()
     * @property _IH_User_C|User[] $users
     * @property-read int $users_count
     * @method HasMany|_IH_User_QB users()
     * @method static _IH_Company_QB onWriteConnection()
     * @method _IH_Company_QB newQuery()
     * @method static _IH_Company_QB on(null|string $connection = null)
     * @method static _IH_Company_QB query()
     * @method static _IH_Company_QB with(array|string $relations)
     * @method _IH_Company_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Company_C|Company[] all()
     * @foreignLinks id,\App\Models\User,company_id|id,\App\Models\ProjectDetail,main_client_id|id,\App\Models\ProjectDetail,contractor_id|id,\App\Models\ProjectDetail,sub_client_id|id,\App\Models\ProjectInsurance,company_id
     * @mixin _IH_Company_QB
     */
    class Company extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ContractStatus_QB onWriteConnection()
     * @method _IH_ContractStatus_QB newQuery()
     * @method static _IH_ContractStatus_QB on(null|string $connection = null)
     * @method static _IH_ContractStatus_QB query()
     * @method static _IH_ContractStatus_QB with(array|string $relations)
     * @method _IH_ContractStatus_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContractStatus_C|ContractStatus[] all()
     * @mixin _IH_ContractStatus_QB
     */
    class ContractStatus extends Model {}

    /**
     * @property int $id
     * @property string $code
     * @property string $title
     * @property string $content
     * @property int $user_id
     * @property int $sender_id
     * @property int|null $receiver_id
     * @property int $classification_id
     * @property int|null $project_id
     * @property string $type
     * @property string|null $unique_code
     * @property bool $signed
     * @property string|null $signature_position
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Attachment_C|Attachment[] $attachments
     * @property-read int $attachments_count
     * @method HasMany|_IH_Attachment_QB attachments()
     * @property Classification $classification
     * @method BelongsTo|_IH_Classification_QB classification()
     * @property User $creator
     * @method BelongsTo|_IH_User_QB creator()
     * @property Project|null $project
     * @method BelongsTo|_IH_Project_QB project()
     * @property User|null $receiver
     * @method BelongsTo|_IH_User_QB receiver()
     * @property _IH_Referral_C|Referral[] $referrals
     * @property-read int $referrals_count
     * @method HasMany|_IH_Referral_QB referrals()
     * @property User $sender
     * @method BelongsTo|_IH_User_QB sender()
     * @property _IH_LetterView_C|LetterView[] $views
     * @property-read int $views_count
     * @method HasMany|_IH_LetterView_QB views()
     * @method static _IH_Letter_QB onWriteConnection()
     * @method _IH_Letter_QB newQuery()
     * @method static _IH_Letter_QB on(null|string $connection = null)
     * @method static _IH_Letter_QB query()
     * @method static _IH_Letter_QB with(array|string $relations)
     * @method _IH_Letter_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Letter_C|Letter[] all()
     * @ownLinks user_id,\App\Models\User,id|sender_id,\App\Models\User,id|receiver_id,\App\Models\User,id|classification_id,\App\Models\Classification,id|project_id,\App\Models\Project,id
     * @foreignLinks id,\App\Models\Attachment,letter_id|id,\App\Models\Referral,letter_id|id,\App\Models\LetterView,letter_id
     * @mixin _IH_Letter_QB
     */
    class Letter extends Model {}

    /**
     * @property int $id
     * @property int $letter_id
     * @property int $user_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Letter $letter
     * @method BelongsTo|_IH_Letter_QB letter()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_LetterView_QB onWriteConnection()
     * @method _IH_LetterView_QB newQuery()
     * @method static _IH_LetterView_QB on(null|string $connection = null)
     * @method static _IH_LetterView_QB query()
     * @method static _IH_LetterView_QB with(array|string $relations)
     * @method _IH_LetterView_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_LetterView_C|LetterView[] all()
     * @ownLinks letter_id,\App\Models\Letter,id|user_id,\App\Models\User,id
     * @mixin _IH_LetterView_QB
     */
    class LetterView extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Permission_QB onWriteConnection()
     * @method _IH_Permission_QB newQuery()
     * @method static _IH_Permission_QB on(null|string $connection = null)
     * @method static _IH_Permission_QB query()
     * @method static _IH_Permission_QB with(array|string $relations)
     * @method _IH_Permission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Permission_C|Permission[] all()
     * @foreignLinks id,\App\Models\UserPermission,permission_id
     * @mixin _IH_Permission_QB
     */
    class Permission extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ProjectType_C|ProjectType[] $projectTypes
     * @property-read int $project_types_count
     * @method BelongsToMany|_IH_ProjectType_QB projectTypes()
     * @property ProjectDetail $projectdetail
     * @method HasOne|_IH_ProjectDetail_QB projectdetail()
     * @property projectFinancialDetail $projectfinancialdetail
     * @method HasOne|_IH_projectFinancialDetail_QB projectfinancialdetail()
     * @property _IH_ProjectInsurance_C|ProjectInsurance[] $projectinsurances
     * @property-read int $projectinsurances_count
     * @method HasMany|_IH_ProjectInsurance_QB projectinsurances()
     * @property ProjectSchedule $projectschedule
     * @method HasOne|_IH_ProjectSchedule_QB projectschedule()
     * @property _IH_Section_C|Section[] $sections
     * @property-read int $sections_count
     * @method HasMany|_IH_Section_QB sections()
     * @property _IH_User_C|User[] $users
     * @property-read int $users_count
     * @method BelongsToMany|_IH_User_QB users()
     * @method static _IH_Project_QB onWriteConnection()
     * @method _IH_Project_QB newQuery()
     * @method static _IH_Project_QB on(null|string $connection = null)
     * @method static _IH_Project_QB query()
     * @method static _IH_Project_QB with(array|string $relations)
     * @method _IH_Project_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Project_C|Project[] all()
     * @foreignLinks id,\App\Models\Letter,project_id|id,\App\Models\UserRole,project_id|id,\App\Models\UserPermission,project_id|id,\App\Models\ProjectFile,project_id|id,\App\Models\ProjectDetail,project_id|id,\App\Models\ProjectInsurance,project_id|id,\App\Models\ProjectSchedule,project_id|id,\App\Models\ProjectFinancialDetail,project_id|id,\App\Models\Section,project_id
     * @mixin _IH_Project_QB
     */
    class Project extends Model {}

    /**
     * @property int $id
     * @property int $project_id
     * @property int $manager_id
     * @property string $project_code
     * @property string $tax_code
     * @property int $main_client_id
     * @property int|null $contractor_id
     * @property int|null $sub_client_id
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Company|null $contractor
     * @method BelongsTo|_IH_Company_QB contractor()
     * @property Company $mainClient
     * @method BelongsTo|_IH_Company_QB mainClient()
     * @property User $manager
     * @method BelongsTo|_IH_User_QB manager()
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @property Company $subClient
     * @method BelongsTo|_IH_Company_QB subClient()
     * @method static _IH_ProjectDetail_QB onWriteConnection()
     * @method _IH_ProjectDetail_QB newQuery()
     * @method static _IH_ProjectDetail_QB on(null|string $connection = null)
     * @method static _IH_ProjectDetail_QB query()
     * @method static _IH_ProjectDetail_QB with(array|string $relations)
     * @method _IH_ProjectDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectDetail_C|ProjectDetail[] all()
     * @ownLinks project_id,\App\Models\Project,id|manager_id,\App\Models\User,id|main_client_id,\App\Models\Company,id|contractor_id,\App\Models\Company,id|sub_client_id,\App\Models\Company,id
     * @mixin _IH_ProjectDetail_QB
     */
    class ProjectDetail extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $description
     * @property string $path
     * @property int $user_id
     * @property int $project_id
     * @property int $section_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @property Section $section
     * @method BelongsTo|_IH_Section_QB section()
     * @method static _IH_ProjectFile_QB onWriteConnection()
     * @method _IH_ProjectFile_QB newQuery()
     * @method static _IH_ProjectFile_QB on(null|string $connection = null)
     * @method static _IH_ProjectFile_QB query()
     * @method static _IH_ProjectFile_QB with(array|string $relations)
     * @method _IH_ProjectFile_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectFile_C|ProjectFile[] all()
     * @ownLinks user_id,\App\Models\User,id|project_id,\App\Models\Project,id|section_id,\App\Models\Section,id
     * @mixin _IH_ProjectFile_QB
     */
    class ProjectFile extends Model {}

    /**
     * @property int $id
     * @property int $project_id
     * @property string|null $contract_value
     * @property string|null $currency_unit
     * @property string|null $exchange_rate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @method static _IH_ProjectFinancialDetail_QB onWriteConnection()
     * @method _IH_ProjectFinancialDetail_QB newQuery()
     * @method static _IH_ProjectFinancialDetail_QB on(null|string $connection = null)
     * @method static _IH_ProjectFinancialDetail_QB query()
     * @method static _IH_ProjectFinancialDetail_QB with(array|string $relations)
     * @method _IH_ProjectFinancialDetail_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectFinancialDetail_C|ProjectFinancialDetail[] all()
     * @ownLinks project_id,\App\Models\Project,id
     * @mixin _IH_ProjectFinancialDetail_QB
     */
    class ProjectFinancialDetail extends Model {}

    /**
     * @property int $id
     * @property int $project_id
     * @property int $company_id
     * @property Carbon|null $start_date
     * @property Carbon|null $end_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @method static _IH_ProjectInsurance_QB onWriteConnection()
     * @method _IH_ProjectInsurance_QB newQuery()
     * @method static _IH_ProjectInsurance_QB on(null|string $connection = null)
     * @method static _IH_ProjectInsurance_QB query()
     * @method static _IH_ProjectInsurance_QB with(array|string $relations)
     * @method _IH_ProjectInsurance_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectInsurance_C|ProjectInsurance[] all()
     * @ownLinks project_id,\App\Models\Project,id|company_id,\App\Models\Company,id
     * @mixin _IH_ProjectInsurance_QB
     */
    class ProjectInsurance extends Model {}

    /**
     * @method static _IH_ProjectProjectType_QB onWriteConnection()
     * @method _IH_ProjectProjectType_QB newQuery()
     * @method static _IH_ProjectProjectType_QB on(null|string $connection = null)
     * @method static _IH_ProjectProjectType_QB query()
     * @method static _IH_ProjectProjectType_QB with(array|string $relations)
     * @method _IH_ProjectProjectType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectProjectType_C|ProjectProjectType[] all()
     * @mixin _IH_ProjectProjectType_QB
     */
    class ProjectProjectType extends Model {}

    /**
     * @property int $id
     * @property int $project_id
     * @property Carbon $LOA_date
     * @property Carbon|null $contract_date
     * @property Carbon|null $actual_completion_date
     * @property int $execution_duration
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @method static _IH_ProjectSchedule_QB onWriteConnection()
     * @method _IH_ProjectSchedule_QB newQuery()
     * @method static _IH_ProjectSchedule_QB on(null|string $connection = null)
     * @method static _IH_ProjectSchedule_QB query()
     * @method static _IH_ProjectSchedule_QB with(array|string $relations)
     * @method _IH_ProjectSchedule_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectSchedule_C|ProjectSchedule[] all()
     * @ownLinks project_id,\App\Models\Project,id
     * @mixin _IH_ProjectSchedule_QB
     */
    class ProjectSchedule extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ProjectType_C|ProjectType[] $projeces
     * @property-read int $projeces_count
     * @method BelongsToMany|_IH_ProjectType_QB projeces()
     * @method static _IH_ProjectType_QB onWriteConnection()
     * @method _IH_ProjectType_QB newQuery()
     * @method static _IH_ProjectType_QB on(null|string $connection = null)
     * @method static _IH_ProjectType_QB query()
     * @method static _IH_ProjectType_QB with(array|string $relations)
     * @method _IH_ProjectType_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProjectType_C|ProjectType[] all()
     * @foreignLinks
     * @mixin _IH_ProjectType_QB
     */
    class ProjectType extends Model {}

    /**
     * @property int $id
     * @property int $letter_id
     * @property int $user_id
     * @property string $type
     * @property string|null $comment
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Letter $letter
     * @method BelongsTo|_IH_Letter_QB letter()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Referral_QB onWriteConnection()
     * @method _IH_Referral_QB newQuery()
     * @method static _IH_Referral_QB on(null|string $connection = null)
     * @method static _IH_Referral_QB query()
     * @method static _IH_Referral_QB with(array|string $relations)
     * @method _IH_Referral_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Referral_C|Referral[] all()
     * @ownLinks letter_id,\App\Models\Letter,id|user_id,\App\Models\User,id
     * @mixin _IH_Referral_QB
     */
    class Referral extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Role_QB onWriteConnection()
     * @method _IH_Role_QB newQuery()
     * @method static _IH_Role_QB on(null|string $connection = null)
     * @method static _IH_Role_QB query()
     * @method static _IH_Role_QB with(array|string $relations)
     * @method _IH_Role_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Role_C|Role[] all()
     * @foreignLinks id,\App\Models\UserRole,role_id
     * @mixin _IH_Role_QB
     */
    class Role extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property int $project_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_ProjectFile_C|ProjectFile[] $files
     * @property-read int $files_count
     * @method HasMany|_IH_ProjectFile_QB files()
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @method static _IH_Section_QB onWriteConnection()
     * @method _IH_Section_QB newQuery()
     * @method static _IH_Section_QB on(null|string $connection = null)
     * @method static _IH_Section_QB query()
     * @method static _IH_Section_QB with(array|string $relations)
     * @method _IH_Section_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Section_C|Section[] all()
     * @ownLinks project_id,\App\Models\Project,id
     * @foreignLinks id,\App\Models\ProjectFile,section_id
     * @mixin _IH_Section_QB
     */
    class Section extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $ncode
     * @property string|null $mobile
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $image
     * @property string|null $sign
     * @property string $role
     * @property string $status
     * @property string|null $degree
     * @property string|null $gender
     * @property string|null $address
     * @property int|null $company_id
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Company $company
     * @method HasOne|_IH_Company_QB company()
     * @property _IH_ProjectDetail_C|ProjectDetail[] $managedProjects
     * @property-read int $managed_projects_count
     * @method HasMany|_IH_ProjectDetail_QB managedProjects()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Project_C|Project[] $projects
     * @property-read int $projects_count
     * @method BelongsToMany|_IH_Project_QB projects()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Section_C|Section[] $sections
     * @property-read int $sections_count
     * @method HasMany|_IH_Section_QB sections()
     * @property _IH_DatabaseNotification_C|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @ownLinks company_id,\App\Models\Company,id
     * @foreignLinks id,\App\Models\Letter,user_id|id,\App\Models\Letter,sender_id|id,\App\Models\Letter,receiver_id|id,\App\Models\UserRole,user_id|id,\App\Models\UserPermission,user_id|id,\App\Models\ProjectFile,user_id|id,\App\Models\ProjectDetail,manager_id|id,\App\Models\Referral,user_id|id,\App\Models\LetterView,user_id|id,\App\Models\UserPosition,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property int $permission_id
     * @property int $project_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Permission $permission
     * @method BelongsTo|_IH_Permission_QB permission()
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UserPermission_QB onWriteConnection()
     * @method _IH_UserPermission_QB newQuery()
     * @method static _IH_UserPermission_QB on(null|string $connection = null)
     * @method static _IH_UserPermission_QB query()
     * @method static _IH_UserPermission_QB with(array|string $relations)
     * @method _IH_UserPermission_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserPermission_C|UserPermission[] all()
     * @ownLinks user_id,\App\Models\User,id|permission_id,\App\Models\Permission,id|project_id,\App\Models\Project,id
     * @mixin _IH_UserPermission_QB
     */
    class UserPermission extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property string $position
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_User_C|User[] $users
     * @property-read int $users_count
     * @method BelongsToMany|_IH_User_QB users()
     * @method static _IH_UserPosition_QB onWriteConnection()
     * @method _IH_UserPosition_QB newQuery()
     * @method static _IH_UserPosition_QB on(null|string $connection = null)
     * @method static _IH_UserPosition_QB query()
     * @method static _IH_UserPosition_QB with(array|string $relations)
     * @method _IH_UserPosition_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserPosition_C|UserPosition[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks
     * @mixin _IH_UserPosition_QB
     */
    class UserPosition extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property int $role_id
     * @property int $project_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_UserPosition_C|UserPosition[] $positions
     * @property-read int $positions_count
     * @method BelongsToMany|_IH_UserPosition_QB positions()
     * @property Project $project
     * @method BelongsTo|_IH_Project_QB project()
     * @property Role $role
     * @method BelongsTo|_IH_Role_QB role()
     * @property User $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_UserRole_QB onWriteConnection()
     * @method _IH_UserRole_QB newQuery()
     * @method static _IH_UserRole_QB on(null|string $connection = null)
     * @method static _IH_UserRole_QB query()
     * @method static _IH_UserRole_QB with(array|string $relations)
     * @method _IH_UserRole_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserRole_C|UserRole[] all()
     * @ownLinks user_id,\App\Models\User,id|role_id,\App\Models\Role,id|project_id,\App\Models\Project,id
     * @mixin _IH_UserRole_QB
     */
    class UserRole extends Model {}
}
